/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;

public class TransactionWriter {
    private final LogBuffer buffer;
    private final int localId;

    public TransactionWriter(LogBuffer buffer, int localId) {
        this.buffer = buffer;
        this.localId = localId;
    }

    public void start(int masterId, int myId) throws IOException {
        this.start(XidImpl.getNewGlobalId(), masterId, myId, System.currentTimeMillis());
    }

    public void start(byte[] globalId, int masterId, int myId, long startTimestamp) throws IOException {
        XidImpl xid = new XidImpl(globalId, NeoStoreXaDataSource.BRANCH_ID);
        LogIoUtils.writeStart(this.buffer, this.localId, xid, masterId, myId, startTimestamp);
    }

    public void prepare() throws IOException {
        this.prepare(System.currentTimeMillis());
    }

    public void prepare(long prepareTimestamp) throws IOException {
        LogIoUtils.writePrepare(this.buffer, this.localId, prepareTimestamp);
    }

    public void commit(boolean twoPhase, long txId) throws IOException {
        this.commit(twoPhase, txId, System.currentTimeMillis());
    }

    public void commit(boolean twoPhase, long txId, long commitTimestamp) throws IOException {
        LogIoUtils.writeCommit(twoPhase, this.buffer, this.localId, txId, commitTimestamp);
    }

    public void done() throws IOException {
        LogIoUtils.writeDone(this.buffer, this.localId);
    }

    public void propertyKey(int id, String key, int ... dynamicIds) throws IOException {
        this.write(new Command.PropertyIndexCommand(null, TransactionWriter.withName(new PropertyIndexRecord(id), dynamicIds, key)));
    }

    public void relationshipType(int id, String label, int ... dynamicIds) throws IOException {
        this.write(new Command.RelationshipTypeCommand(null, TransactionWriter.withName(new RelationshipTypeRecord(id), dynamicIds, label)));
    }

    public void update(NeoStoreRecord record) throws IOException {
        this.write(new Command.NeoStoreCommand(null, record));
    }

    public void create(NodeRecord node) throws IOException {
        node.setCreated();
        this.update(node);
    }

    public void update(NodeRecord node) throws IOException {
        node.setInUse(true);
        this.add(node);
    }

    public void delete(NodeRecord node) throws IOException {
        node.setInUse(false);
        this.add(node);
    }

    public void create(RelationshipRecord relationship) throws IOException {
        relationship.setCreated();
        this.update(relationship);
    }

    public void update(RelationshipRecord relationship) throws IOException {
        relationship.setInUse(true);
        this.add(relationship);
    }

    public void delete(RelationshipRecord relationship) throws IOException {
        relationship.setInUse(false);
        this.add(relationship);
    }

    public void create(PropertyRecord property) throws IOException {
        property.setCreated();
        this.update(property);
    }

    public void update(PropertyRecord property) throws IOException {
        property.setInUse(true);
        this.add(property);
    }

    public void delete(PropertyRecord property) throws IOException {
        property.setInUse(false);
        this.add(property);
    }

    public void add(NodeRecord node) throws IOException {
        this.write(new Command.NodeCommand(null, node));
    }

    public void add(RelationshipRecord relationship) throws IOException {
        this.write(new Command.RelationshipCommand(null, relationship));
    }

    public void add(PropertyRecord property) throws IOException {
        this.write(new Command.PropertyCommand(null, property));
    }

    public void add(RelationshipTypeRecord record) throws IOException {
        this.write(new Command.RelationshipTypeCommand(null, record));
    }

    public void add(PropertyIndexRecord record) throws IOException {
        this.write(new Command.PropertyIndexCommand(null, record));
    }

    public void add(NeoStoreRecord record) throws IOException {
        this.write(new Command.NeoStoreCommand(null, record));
    }

    private void write(Command command) throws IOException {
        LogIoUtils.writeCommand(this.buffer, this.localId, command);
    }

    private static <T extends AbstractNameRecord> T withName(T record, int[] dynamicIds, String name) {
        if (dynamicIds == null || dynamicIds.length == 0) {
            throw new IllegalArgumentException("No dynamic records for storing the name.");
        }
        record.setInUse(true);
        byte[] data = PropertyStore.encodeString(name);
        if (data.length > dynamicIds.length * 30) {
            throw new IllegalArgumentException(String.format("[%s] is too long to fit in %d blocks", name, dynamicIds.length));
        }
        if (data.length <= (dynamicIds.length - 1) * 30) {
            throw new IllegalArgumentException(String.format("[%s] is to short to fill %d blocks", name, dynamicIds.length));
        }
        for (int i = 0; i < dynamicIds.length; ++i) {
            byte[] part = new byte[Math.min(30, data.length - i * 30)];
            System.arraycopy(data, i * 30, part, 0, part.length);
            DynamicRecord dynamicRecord = new DynamicRecord(dynamicIds[i]);
            dynamicRecord.setInUse(true);
            dynamicRecord.setData(part);
            dynamicRecord.setCreated();
            record.addNameRecord(dynamicRecord);
        }
        record.setNameId(dynamicIds[0]);
        return record;
    }
}

