/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.graphdb.index.IndexProviderKernelExtensionFactory;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.helpers.DaemonThreadFactory;
import org.neo4j.helpers.Factory;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.IndexManagerImpl;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelDiagnostics;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.NodeAutoIndexerImpl;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.RelationshipAutoIndexerImpl;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.TransactionBuilderImpl;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.MonitorGc;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.DefaultCaches;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.ReadOnlyNodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockManagerImpl;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.ReadOnlyTxManager;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.TransactionManagerProvider;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.logging.DefaultLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.tooling.Clock;
import org.neo4j.tooling.GlobalGraphOperations;

public abstract class InternalAbstractGraphDatabase
extends AbstractGraphDatabase
implements GraphDatabaseService,
GraphDatabaseAPI {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private static final long MAX_RELATIONSHIP_ID = IdType.RELATIONSHIP.getMaxValue();
    protected File storeDir;
    protected Map<String, String> params;
    private TransactionInterceptorProviders transactionInterceptorProviders;
    private final KernelExtensions kernelExtensions;
    protected StoreId storeId;
    private final TransactionBuilder defaultTxBuilder = new TransactionBuilderImpl(this, ForceMode.forced);
    protected Config config;
    protected DependencyResolver dependencyResolver;
    protected Logging logging;
    protected StringLogger msgLog;
    protected StoreLockerLifecycleAdapter storeLocker;
    protected KernelEventHandlers kernelEventHandlers;
    protected TransactionEventHandlers transactionEventHandlers;
    protected RelationshipTypeHolder relationshipTypeHolder;
    protected NodeManager nodeManager;
    protected IndexManagerImpl indexManager;
    protected KernelPanicEventGenerator kernelPanicEventGenerator;
    protected KernelHealth kernelHealth;
    protected RemoteTxHook txHook;
    protected FileSystemAbstraction fileSystem;
    protected XaDataSourceManager xaDataSourceManager;
    protected LockManager lockManager;
    protected IdGeneratorFactory idGeneratorFactory;
    protected RelationshipTypeCreator relationshipTypeCreator;
    protected NioNeoDbPersistenceSource persistenceSource;
    protected TxEventSyncHookFactory syncHook;
    protected PersistenceManager persistenceManager;
    protected PropertyIndexManager propertyIndexManager;
    protected IndexStore indexStore;
    protected AbstractTransactionManager txManager;
    protected TxIdGenerator txIdGenerator;
    protected StoreFactory storeFactory;
    protected XaFactory xaFactory;
    protected DiagnosticsManager diagnosticsManager;
    protected NeoStoreXaDataSource neoDataSource;
    protected RecoveryVerifier recoveryVerifier;
    protected Guard guard;
    protected NodeAutoIndexerImpl nodeAutoIndexer;
    protected RelationshipAutoIndexerImpl relAutoIndexer;
    protected KernelData extensions;
    protected Caches caches;
    protected Monitors monitors;
    protected final LifeSupport life = new LifeSupport();
    private final Map<String, CacheProvider> cacheProviders;
    protected TransactionStateFactory stateFactory;
    protected AvailabilityGuard availabilityGuard;
    protected long accessTimeout;

    protected InternalAbstractGraphDatabase(String storeDir, Map<String, String> params, Dependencies dependencies) {
        this.params = params;
        this.dependencyResolver = new DependencyResolverImpl();
        params.put(Configuration.store_dir.name(), storeDir);
        this.cacheProviders = this.mapCacheProviders(dependencies.cacheProviders());
        this.config = new Config(params, this.getSettingsClasses(dependencies.settingsClasses(), dependencies.kernelExtensions(), dependencies.cacheProviders()));
        this.logging = dependencies.logging();
        Iterable indexProviderKernelExtensions = Iterables.map(new Function<IndexProvider, KernelExtensionFactory<?>>(){

            @Override
            public KernelExtensionFactory<?> apply(IndexProvider from) {
                return new IndexProviderKernelExtensionFactory(from);
            }
        }, dependencies.indexProviders());
        Iterable<KernelExtensionFactory<?>> kernelExtensions = Iterables.concat(dependencies.kernelExtensions(), indexProviderKernelExtensions);
        this.kernelExtensions = new KernelExtensions(kernelExtensions, this.config, this.getDependencyResolver());
        this.transactionInterceptorProviders = new TransactionInterceptorProviders(dependencies.transactionInterceptorProviders(), this.dependencyResolver);
        this.storeDir = this.config.get(Configuration.store_dir);
        this.accessTimeout = 1000L;
    }

    private Map<String, CacheProvider> mapCacheProviders(Iterable<CacheProvider> cacheProviders) {
        HashMap<String, CacheProvider> map = new HashMap<String, CacheProvider>();
        for (CacheProvider provider : cacheProviders) {
            map.put(provider.getName(), provider);
        }
        return map;
    }

    protected void run() {
        this.create();
        try {
            this.registerRecovery();
            this.life.start();
            if (this.txManager.getRecoveryError() != null) {
                throw this.txManager.getRecoveryError();
            }
        }
        catch (Throwable throwable) {
            StringBuilder msg = new StringBuilder();
            msg.append("Startup failed");
            for (Throwable temporaryThrowable = throwable; temporaryThrowable != null; temporaryThrowable = temporaryThrowable.getCause()) {
                msg.append(": ").append(temporaryThrowable.getMessage());
            }
            this.msgLog.logMessage(msg.toString());
            this.shutdown();
            throw new RuntimeException(throwable);
        }
    }

    protected void createDatabaseAvailability() {
        this.life.add(new DatabaseAvailability(this.txManager, this.availabilityGuard));
    }

    protected void registerRecovery() {
        this.life.addLifecycleListener(new LifecycleListener(){

            @Override
            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance instanceof KernelExtensions && to.equals((Object)LifecycleStatus.STARTED) && InternalAbstractGraphDatabase.this.txManager instanceof TxManager) {
                    InternalAbstractGraphDatabase.this.doAfterRecoveryAndStartup();
                }
            }
        });
    }

    protected void doAfterRecoveryAndStartup() {
        NeoStoreXaDataSource neoStoreDataSource = this.xaDataSourceManager.getNeoStoreDataSource();
        this.storeId = neoStoreDataSource.getStoreId();
        KernelDiagnostics.register(this.diagnosticsManager, this, neoStoreDataSource);
    }

    protected void create() {
        this.availabilityGuard = this.createAvailabilityGuard();
        this.availabilityGuard.addListener(new AvailabilityGuard.AvailabilityListener(){

            @Override
            public void available() {
                InternalAbstractGraphDatabase.this.msgLog.logMessage("Database is now ready");
            }

            @Override
            public void unavailable() {
                InternalAbstractGraphDatabase.this.msgLog.logMessage("Database is no longer ready");
            }
        });
        this.fileSystem = this.createFileSystemAbstraction();
        if (this.logging == null) {
            this.logging = this.createLogging();
        }
        this.monitors = new Monitors();
        AutoConfigurator autoConfigurator = new AutoConfigurator(this.fileSystem, this.config.get(NeoStoreXaDataSource.Configuration.store_dir), GraphDatabaseSettings.UseMemoryMappedBuffers.shouldMemoryMap(this.config.get(Configuration.use_memory_mapped_buffers)), this.logging.getConsoleLog(AutoConfigurator.class));
        if (this.config.get(GraphDatabaseSettings.dump_configuration).booleanValue()) {
            System.out.println(autoConfigurator.getNiceMemoryInformation());
        }
        Map<String, String> configParams = this.config.getParams();
        Map<String, String> autoConfiguration = autoConfigurator.configure();
        for (Map.Entry<String, String> autoConfig : autoConfiguration.entrySet()) {
            String key = autoConfig.getKey();
            if (this.params.containsKey(key)) continue;
            configParams.put(key, autoConfig.getValue());
        }
        this.config.applyChanges(configParams);
        this.msgLog = this.logging.getMessagesLog(this.getClass());
        this.config.setLogger(this.msgLog);
        this.storeLocker = this.life.add(new StoreLockerLifecycleAdapter(new StoreLocker(this.fileSystem), this.storeDir));
        new JvmChecker(this.msgLog, new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        boolean readOnly = this.config.get(Configuration.read_only);
        String cacheTypeName = this.config.get(Configuration.cache_type);
        CacheProvider cacheProvider = this.cacheProviders.get(cacheTypeName);
        if (cacheProvider == null) {
            throw new IllegalArgumentException("No provider for cache type '" + cacheTypeName + "'. " + "Cache providers are loaded using java service loading where they " + "register themselves in resource (plain-text) files found on the class path under " + "META-INF/services/" + CacheProvider.class.getName() + ". This missing provider may have " + "been caused by either such a missing registration, or by the lack of the provider class itself.");
        }
        this.kernelEventHandlers = new KernelEventHandlers(this.logging.getMessagesLog(KernelEventHandlers.class));
        this.caches = this.createCaches();
        this.diagnosticsManager = this.life.add(new DiagnosticsManager(this.logging.getMessagesLog(DiagnosticsManager.class)));
        this.kernelPanicEventGenerator = new KernelPanicEventGenerator(this.kernelEventHandlers);
        this.kernelHealth = new KernelHealth(this.kernelPanicEventGenerator, this.logging);
        this.xaDataSourceManager = this.life.add(this.createXaDataSourceManager());
        this.txHook = this.createTxHook();
        this.guard = this.config.get(Configuration.execution_guard_enabled) != false ? new Guard(this.msgLog) : null;
        this.stateFactory = this.createTransactionStateFactory();
        Factory<byte[]> xidGlobalIdFactory = this.createXidGlobalIdFactory();
        if (readOnly) {
            this.txManager = new ReadOnlyTxManager(this.xaDataSourceManager, xidGlobalIdFactory, this.logging.getMessagesLog(ReadOnlyTxManager.class));
        } else {
            String serviceName = this.config.get(GraphDatabaseSettings.tx_manager_impl);
            if (GraphDatabaseSettings.tx_manager_impl.getDefaultValue().equals(serviceName)) {
                this.txManager = new TxManager(this.storeDir, this.xaDataSourceManager, this.logging.getMessagesLog(TxManager.class), this.fileSystem, this.stateFactory, xidGlobalIdFactory, this.kernelHealth, this.monitors);
            } else {
                TransactionManagerProvider provider = Service.load(TransactionManagerProvider.class, serviceName);
                if (provider == null) {
                    throw new IllegalStateException("Unknown transaction manager implementation: " + serviceName);
                }
                this.txManager = provider.loadTransactionManager(this.storeDir.getPath(), this.xaDataSourceManager, this.kernelPanicEventGenerator, this.txHook, this.logging.getMessagesLog(AbstractTransactionManager.class), this.fileSystem, this.stateFactory);
            }
        }
        this.life.add(this.txManager);
        this.transactionEventHandlers = new TransactionEventHandlers(this.txManager);
        this.txIdGenerator = this.life.add(this.createTxIdGenerator());
        this.lockManager = this.createLockManager();
        this.idGeneratorFactory = this.createIdGeneratorFactory();
        this.relationshipTypeCreator = this.createRelationshipTypeCreator();
        this.persistenceSource = this.life.add(new NioNeoDbPersistenceSource(this.xaDataSourceManager));
        this.syncHook = new DefaultTxEventSyncHookFactory();
        this.persistenceManager = new PersistenceManager(this.logging.getMessagesLog(PersistenceManager.class), this.txManager, this.persistenceSource, this.syncHook);
        this.propertyIndexManager = this.life.add(new PropertyIndexManager(this.persistenceManager, this.persistenceSource));
        this.relationshipTypeHolder = this.life.add(new RelationshipTypeHolder(this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeCreator));
        this.caches.configure(cacheProvider, this.config);
        Cache<NodeImpl> nodeCache = this.diagnosticsManager.tryAppendProvider(this.caches.node());
        Cache<RelationshipImpl> relCache = this.diagnosticsManager.tryAppendProvider(this.caches.relationship());
        this.nodeManager = this.guard != null ? this.createGuardedNodeManager(readOnly, cacheProvider, nodeCache, relCache) : this.createNodeManager(readOnly, cacheProvider, nodeCache, relCache);
        this.stateFactory.setDependencies(this.lockManager, this.propertyIndexManager, this.nodeManager, this.txHook, this.txIdGenerator);
        this.indexStore = this.life.add(new IndexStore(this.storeDir, this.fileSystem));
        this.diagnosticsManager.prependProvider(this.config);
        this.params = this.config.getParams();
        this.extensions = this.life.add(this.createKernelData());
        if (this.config.get(Configuration.load_kernel_extensions).booleanValue()) {
            this.life.add(this.kernelExtensions);
        }
        this.indexManager = new IndexManagerImpl(this.config, this.indexStore, this.xaDataSourceManager, this.txManager, this);
        this.nodeAutoIndexer = this.life.add(new NodeAutoIndexerImpl(this.config, this.indexManager, this.nodeManager));
        this.relAutoIndexer = this.life.add(new RelationshipAutoIndexerImpl(this.config, this.indexManager, this.nodeManager));
        this.indexManager.setNodeAutoIndexer(this.nodeAutoIndexer);
        this.indexManager.setRelAutoIndexer(this.relAutoIndexer);
        this.recoveryVerifier = this.createRecoveryVerifier();
        this.storeFactory = this.createStoreFactory();
        String keepLogicalLogsConfig = this.config.get(GraphDatabaseSettings.keep_logical_logs);
        this.xaFactory = new XaFactory(this.config, this.txIdGenerator, this.txManager, this.fileSystem, this.monitors, this.logging, this.recoveryVerifier, LogPruneStrategies.fromConfigValue(this.fileSystem, keepLogicalLogsConfig), this.kernelHealth);
        this.createNeoDataSource();
        this.life.add(new MonitorGc(this.config, this.msgLog));
        this.life.add(this.nodeManager);
        this.createDatabaseAvailability();
        this.life.add(this.kernelEventHandlers);
        this.life.add(new ConfigurationChangedRestarter());
    }

    protected Factory<byte[]> createXidGlobalIdFactory() {
        return new Factory<byte[]>(){

            @Override
            public byte[] newInstance() {
                return XidImpl.getNewGlobalId(XidImpl.DEFAULT_SEED, -1);
            }
        };
    }

    protected AvailabilityGuard createAvailabilityGuard() {
        return new AvailabilityGuard(Clock.REAL_CLOCK, 1);
    }

    protected TransactionStateFactory createTransactionStateFactory() {
        return new TransactionStateFactory(this.logging);
    }

    protected XaDataSourceManager createXaDataSourceManager() {
        return new XaDataSourceManager(this.logging.getMessagesLog(XaDataSourceManager.class));
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected RelationshipTypeCreator createRelationshipTypeCreator() {
        return new DefaultRelationshipTypeCreator();
    }

    private NodeManager createNodeManager(boolean readOnly, CacheProvider cacheType, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache) {
        if (readOnly) {
            return new ReadOnlyNodeManager(this.config, this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager);
        }
        return new NodeManager(this.config, this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager);
    }

    private NodeManager createGuardedNodeManager(boolean readOnly, CacheProvider cacheType, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache) {
        if (readOnly) {
            return new ReadOnlyNodeManager(this.config, this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager){

                @Override
                protected Node getNodeByIdOrNull(long nodeId) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getNodeByIdOrNull(nodeId);
                }

                @Override
                public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getNodeForProxy(nodeId, lock);
                }

                @Override
                public RelationshipImpl getRelationshipForProxy(long relId, LockType lock) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getRelationshipForProxy(relId, lock);
                }

                @Override
                protected Relationship getRelationshipByIdOrNull(long relId) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getRelationshipByIdOrNull(relId);
                }

                @Override
                public Node createNode() {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.createNode();
                }

                @Override
                public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, RelationshipType type) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.createRelationship(startNodeProxy, startNode, endNode, type);
                }
            };
        }
        return new NodeManager(this.config, this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager){

            @Override
            protected Node getNodeByIdOrNull(long nodeId) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getNodeByIdOrNull(nodeId);
            }

            @Override
            public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getNodeForProxy(nodeId, lock);
            }

            @Override
            public RelationshipImpl getRelationshipForProxy(long relId, LockType lock) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getRelationshipForProxy(relId, lock);
            }

            @Override
            protected Relationship getRelationshipByIdOrNull(long relId) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getRelationshipByIdOrNull(relId);
            }

            @Override
            public Node createNode() {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.createNode();
            }

            @Override
            public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, RelationshipType type) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.createRelationship(startNodeProxy, startNode, endNode, type);
            }
        };
    }

    @Override
    public boolean isAvailable(long timeout) {
        return this.availabilityGuard.isAvailable(timeout);
    }

    @Override
    public void shutdown() {
        try {
            this.msgLog.info("Shutdown started");
            this.msgLog.flush();
            this.availabilityGuard.shutdown();
            this.life.shutdown();
        }
        catch (LifecycleException throwable) {
            this.msgLog.warn("Shutdown failed", throwable);
        }
    }

    protected StoreFactory createStoreFactory() {
        return new StoreFactory(this.config, this.idGeneratorFactory, this.createWindowPoolFactory(), this.fileSystem, this.logging.getMessagesLog(StoreFactory.class), this.txHook);
    }

    protected DefaultWindowPoolFactory createWindowPoolFactory() {
        return new DefaultWindowPoolFactory();
    }

    protected RecoveryVerifier createRecoveryVerifier() {
        return RecoveryVerifier.ALWAYS_VALID;
    }

    protected KernelData createKernelData() {
        return new DefaultKernelData(this.config, this);
    }

    protected TxIdGenerator createTxIdGenerator() {
        return TxIdGenerator.DEFAULT;
    }

    protected Caches createCaches() {
        return new DefaultCaches(this.msgLog, this.monitors);
    }

    protected RelationshipProxy.RelationshipLookups createRelationshipLookups() {
        return new RelationshipProxy.RelationshipLookups(){

            @Override
            public Node lookupNode(long nodeId) {
                return InternalAbstractGraphDatabase.this.nodeManager.getNodeById(nodeId);
            }

            @Override
            public RelationshipImpl lookupRelationship(long relationshipId) {
                return InternalAbstractGraphDatabase.this.nodeManager.getRelationshipForProxy(relationshipId, null);
            }

            @Override
            public RelationshipImpl lookupRelationship(long relationshipId, LockType lock) {
                return InternalAbstractGraphDatabase.this.nodeManager.getRelationshipForProxy(relationshipId, lock);
            }

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return InternalAbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return InternalAbstractGraphDatabase.this.nodeManager;
            }

            @Override
            public Node newNodeProxy(long nodeId) {
                return InternalAbstractGraphDatabase.this.nodeManager.newNodeProxyById(nodeId);
            }
        };
    }

    protected NodeProxy.NodeLookup createNodeLookup() {
        return new NodeProxy.NodeLookup(){

            @Override
            public NodeImpl lookup(long nodeId) {
                return InternalAbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, null);
            }

            @Override
            public NodeImpl lookup(long nodeId, LockType lock) {
                return InternalAbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, lock);
            }

            @Override
            public GraphDatabaseService getGraphDatabase() {
                return InternalAbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return InternalAbstractGraphDatabase.this.nodeManager;
            }
        };
    }

    protected RemoteTxHook createTxHook() {
        return new DefaultTxHook();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        return new DefaultIdGeneratorFactory();
    }

    protected LockManager createLockManager() {
        return new LockManagerImpl(new RagManager(this.txManager));
    }

    protected Logging createLogging() {
        return this.life.add(DefaultLogging.createDefaultLogging(this.config));
    }

    protected void createNeoDataSource() {
        try {
            this.neoDataSource = new NeoStoreXaDataSource(this.config, this.storeFactory, this.lockManager, this.logging.getMessagesLog(NeoStoreXaDataSource.class), this.xaFactory, this.stateFactory, this.transactionInterceptorProviders, this.dependencyResolver);
            this.xaDataSourceManager.registerDataSource(this.neoDataSource);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create Neo XA datasource", e);
        }
    }

    @Override
    public final String getStoreDir() {
        return this.storeDir.getPath();
    }

    @Override
    public StoreId getStoreId() {
        return this.storeId;
    }

    @Override
    public Transaction beginTx() {
        return this.tx().begin();
    }

    protected Transaction beginTx(ForceMode forceMode) {
        if (!this.availabilityGuard.isAvailable(this.accessTimeout)) {
            throw new TransactionFailureException("Database is currently not available. " + this.availabilityGuard.describeWhoIsBlocking());
        }
        if (this.transactionRunning()) {
            return new PlaceboTransaction(this.txManager, this.lockManager, this.txManager.getTransactionState());
        }
        TopLevelTransaction result = null;
        try {
            this.txManager.begin(forceMode);
            result = new TopLevelTransaction(this.txManager, this.lockManager, this.txManager.getTransactionState());
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to begin transaction", e);
        }
        return result;
    }

    @Override
    public boolean transactionRunning() {
        try {
            return this.txManager.getTransaction() != null;
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    protected boolean isEphemeral() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return GlobalGraphOperations.at(this).getAllNodes();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return GlobalGraphOperations.at(this).getAllRelationshipTypes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.registerKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.registerTransactionEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.unregisterTransactionEventHandler(handler);
    }

    @Override
    public Node createNode() {
        return this.nodeManager.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new NotFoundException(String.format("Node %d not found", id));
        }
        return this.nodeManager.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > MAX_RELATIONSHIP_ID) {
            throw new NotFoundException(String.format("Relationship %d not found", id));
        }
        return this.nodeManager.getRelationshipById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.nodeManager.getReferenceNode();
    }

    @Override
    public TransactionBuilder tx() {
        return this.defaultTxBuilder;
    }

    @Override
    public Guard getGuard() {
        return this.guard;
    }

    @Override
    public KernelData getKernelData() {
        return this.extensions;
    }

    @Override
    public IndexManager index() {
        return this.indexManager;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public XaDataSourceManager getXaDataSourceManager() {
        return this.xaDataSourceManager;
    }

    @Override
    public TransactionManager getTxManager() {
        return this.txManager;
    }

    @Override
    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.relationshipTypeHolder;
    }

    @Override
    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    @Override
    public DiagnosticsManager getDiagnosticsManager() {
        return this.diagnosticsManager;
    }

    @Override
    public PersistenceSource getPersistenceSource() {
        return this.persistenceSource;
    }

    @Override
    public final StringLogger getMessageLog() {
        return this.msgLog;
    }

    @Override
    public TxIdGenerator getTxIdGenerator() {
        return this.txIdGenerator;
    }

    @Override
    public KernelPanicEventGenerator getKernelPanicGenerator() {
        return this.kernelPanicEventGenerator;
    }

    private Iterable<Class<?>> getSettingsClasses(Iterable<Class<?>> settingsClasses, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders) {
        ArrayList totalSettingsClasses = new ArrayList();
        Iterables.addAll(totalSettingsClasses, settingsClasses);
        for (KernelExtensionFactory<?> kernelExtension : kernelExtensions) {
            if (kernelExtension.getSettingsClass() == null) continue;
            totalSettingsClasses.add(kernelExtension.getSettingsClass());
        }
        for (CacheProvider cacheProvider : cacheProviders) {
            if (cacheProvider.getSettingsClass() == null) continue;
            totalSettingsClasses.add(cacheProvider.getSettingsClass());
        }
        return totalSettingsClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof InternalAbstractGraphDatabase)) {
            return false;
        }
        InternalAbstractGraphDatabase that = (InternalAbstractGraphDatabase)o;
        if (this.getStoreId() != null ? !this.getStoreId().equals(that.getStoreId()) : that.getStoreId() != null) {
            return false;
        }
        return this.storeDir.equals(that.storeDir);
    }

    public int hashCode() {
        return this.storeDir.hashCode();
    }

    private class ConfigurationChangedRestarter
    extends LifecycleAdapter {
        private final ConfigurationChangeListener listener = new ConfigurationChangeListener(){
            Executor executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("Database configuration restart"));

            @Override
            public void notifyConfigurationChanges(final Iterable<ConfigurationChange> change) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InternalAbstractGraphDatabase.this.life.stop();
                            InternalAbstractGraphDatabase.this.life.start();
                            InternalAbstractGraphDatabase.this.msgLog.logMessage("Database restarted with the following configuration changes:" + change);
                        }
                        catch (LifecycleException e) {
                            InternalAbstractGraphDatabase.this.msgLog.logMessage("Could not restart database", e);
                        }
                    }
                });
            }
        };

        private ConfigurationChangedRestarter() {
        }

        @Override
        public void start() throws Throwable {
            InternalAbstractGraphDatabase.this.config.addConfigurationChangeListener(this.listener);
        }

        @Override
        public void stop() throws Throwable {
            InternalAbstractGraphDatabase.this.config.removeConfigurationChangeListener(this.listener);
        }
    }

    class DatabaseStartup
    implements Lifecycle {
        DatabaseStartup() {
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }
    }

    class DependencyResolverImpl
    extends DependencyResolver.Adapter {
        DependencyResolverImpl() {
        }

        private <T> T resolveKnownSingleDependency(Class<T> type) {
            if (type.equals(Map.class)) {
                return (T)InternalAbstractGraphDatabase.this.getConfig().getParams();
            }
            if (type.equals(Config.class)) {
                return (T)InternalAbstractGraphDatabase.this.getConfig();
            }
            if (GraphDatabaseService.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this;
            }
            if (TransactionManager.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.txManager;
            }
            if (LockManager.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.lockManager;
            }
            if (StoreFactory.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.storeFactory;
            }
            if (StringLogger.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.msgLog;
            }
            if (Logging.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.logging;
            }
            if (IndexStore.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.indexStore;
            }
            if (XaFactory.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.xaFactory;
            }
            if (XaDataSourceManager.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.xaDataSourceManager;
            }
            if (FileSystemAbstraction.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.fileSystem;
            }
            if (Guard.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.guard;
            }
            if (IndexProviders.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.indexManager;
            }
            if (KernelData.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.extensions;
            }
            if (Logging.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.logging;
            }
            if (TransactionInterceptorProviders.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.transactionInterceptorProviders;
            }
            if (KernelExtensions.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.kernelExtensions;
            }
            if (NodeManager.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.nodeManager;
            }
            if (TransactionStateFactory.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.stateFactory;
            }
            if (TxIdGenerator.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.txIdGenerator;
            }
            if (DiagnosticsManager.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.diagnosticsManager;
            }
            if (StoreLockerLifecycleAdapter.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.storeLocker;
            }
            if (KernelPanicEventGenerator.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.kernelPanicEventGenerator;
            }
            if (LifeSupport.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.life;
            }
            if (Monitors.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.monitors;
            }
            if (DependencyResolver.class.isAssignableFrom(type)) {
                return (T)this;
            }
            if (KernelHealth.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.kernelHealth;
            }
            return null;
        }

        @Override
        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
            T result = this.resolveKnownSingleDependency(type);
            if (result != null) {
                return selector.select(type, Iterables.option(result));
            }
            return InternalAbstractGraphDatabase.this.kernelExtensions.resolveDependency(type, selector);
        }
    }

    private class DefaultTxEventSyncHookFactory
    implements TxEventSyncHookFactory {
        private DefaultTxEventSyncHookFactory() {
        }

        @Override
        public TransactionEventsSyncHook create() {
            return InternalAbstractGraphDatabase.this.transactionEventHandlers.hasHandlers() ? new TransactionEventsSyncHook(InternalAbstractGraphDatabase.this.transactionEventHandlers, InternalAbstractGraphDatabase.this.txManager) : null;
        }
    }

    protected class DefaultKernelData
    extends KernelData
    implements Lifecycle {
        private final GraphDatabaseAPI graphDb;

        public DefaultKernelData(Config config, GraphDatabaseAPI graphDb) {
            super(config);
            this.graphDb = graphDb;
        }

        @Override
        public Version version() {
            return Version.getKernel();
        }

        @Override
        public GraphDatabaseAPI graphDatabase() {
            return this.graphDb;
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() {
            super.shutdown();
        }
    }

    public static class Configuration {
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<Boolean> use_memory_mapped_buffers = GraphDatabaseSettings.use_memory_mapped_buffers;
        public static final Setting<Boolean> execution_guard_enabled = GraphDatabaseSettings.execution_guard_enabled;
        public static final GraphDatabaseSettings.CacheTypeSetting cache_type = GraphDatabaseSettings.cache_type;
        public static final Setting<Boolean> load_kernel_extensions = GraphDatabaseSettings.load_kernel_extensions;
        public static final Setting<Boolean> ephemeral = new GraphDatabaseSetting.BooleanSetting(Settings.setting("ephemeral", Settings.BOOLEAN, "false"));
        public static final Setting<File> store_dir = GraphDatabaseSettings.store_dir;
        public static final Setting<File> neo_store = GraphDatabaseSettings.neo_store;
        public static final Setting<File> logical_log = GraphDatabaseSettings.logical_log;
    }

    public static interface Dependencies {
        public Logging logging();

        public Iterable<Class<?>> settingsClasses();

        public Iterable<IndexProvider> indexProviders();

        public Iterable<KernelExtensionFactory<?>> kernelExtensions();

        public Iterable<CacheProvider> cacheProviders();

        public Iterable<TransactionInterceptorProvider> transactionInterceptorProviders();
    }
}

