/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class UpgradableDatabase {
    public static final Map<String, String> fileNamesToExpectedVersions;
    private final StoreVersionCheck storeVersionCheck;

    public UpgradableDatabase(StoreVersionCheck storeVersionCheck) {
        this.storeVersionCheck = storeVersionCheck;
    }

    public void checkUpgradeable(File neoStoreFile) {
        if (!this.storeFilesUpgradeable(neoStoreFile)) {
            throw new StoreUpgrader.UnableToUpgradeException("Not all store files match the version required for successful upgrade");
        }
    }

    public boolean storeFilesUpgradeable(File neoStoreFile) {
        File storeDirectory = neoStoreFile.getParentFile();
        for (String fileName : fileNamesToExpectedVersions.keySet()) {
            String expectedVersion;
            if (this.storeVersionCheck.hasVersion(new File(storeDirectory, fileName), expectedVersion = fileNamesToExpectedVersions.get(fileName))) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<String, String> before = new HashMap<String, String>();
        before.put("neostore", "NeoStore v0.9.9");
        before.put("neostore.nodestore.db", "NodeStore v0.9.9");
        before.put("neostore.propertystore.db", "PropertyStore v0.9.9");
        before.put("neostore.propertystore.db.arrays", "ArrayPropertyStore v0.9.9");
        before.put("neostore.propertystore.db.index", "PropertyIndex v0.9.9");
        before.put("neostore.propertystore.db.index.keys", "StringPropertyStore v0.9.9");
        before.put("neostore.propertystore.db.strings", "StringPropertyStore v0.9.9");
        before.put("neostore.relationshipstore.db", "RelationshipStore v0.9.9");
        before.put("neostore.relationshiptypestore.db", "RelationshipTypeStore v0.9.9");
        before.put("neostore.relationshiptypestore.db.names", "StringPropertyStore v0.9.9");
        fileNamesToExpectedVersions = Collections.unmodifiableMap(before);
    }
}

