/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;

class PartialTransactionCopier {
    private final ByteBuffer sharedBuffer;
    private final XaCommandFactory commandFactory;
    private final StringLogger log;
    private final LogExtractor.LogPositionCache positionCache;
    private final LogExtractor.LogLoader logLoader;
    private final ArrayMap<Integer, LogEntry.Start> xidIdentMap;
    private final ByteCounterMonitor monitor;

    PartialTransactionCopier(ByteBuffer sharedBuffer, XaCommandFactory commandFactory, StringLogger log, LogExtractor.LogPositionCache positionCache, LogExtractor.LogLoader logLoader, ArrayMap<Integer, LogEntry.Start> xidIdentMap, ByteCounterMonitor monitor) {
        this.sharedBuffer = sharedBuffer;
        this.commandFactory = commandFactory;
        this.log = log;
        this.positionCache = positionCache;
        this.logLoader = logLoader;
        this.xidIdentMap = xidIdentMap;
        this.monitor = monitor;
    }

    public void copy(StoreChannel sourceLog, LogBuffer targetLog, long targetLogVersion) throws IOException {
        boolean foundFirstActiveTx = false;
        HashMap<Integer, LogEntry.Start> startEntriesEncountered = new HashMap<Integer, LogEntry.Start>();
        LogEntry entry = null;
        while ((entry = LogIoUtils.readEntry(this.sharedBuffer, sourceLog, this.commandFactory)) != null) {
            boolean isActive;
            Integer identifier = entry.getIdentifier();
            boolean bl = isActive = this.xidIdentMap.get(identifier) != null;
            if (!foundFirstActiveTx && isActive) {
                foundFirstActiveTx = true;
            }
            if (!foundFirstActiveTx) continue;
            if (entry instanceof LogEntry.Start) {
                LogEntry.Start startEntry = (LogEntry.Start)entry;
                startEntriesEncountered.put(identifier, startEntry);
                startEntry.setStartPosition(targetLog.getFileChannelPosition());
                if (isActive) {
                    this.xidIdentMap.put(identifier, startEntry);
                }
            } else if (entry instanceof LogEntry.Commit) {
                LogEntry.Commit commitEntry = (LogEntry.Commit)entry;
                LogEntry.Start startEntry = (LogEntry.Start)startEntriesEncountered.get(identifier);
                if (startEntry == null) {
                    startEntry = this.fetchTransactionBulkFromLogExtractor(commitEntry.getTxId(), targetLog);
                    startEntriesEncountered.put(identifier, startEntry);
                } else {
                    LogExtractor.TxPosition oldPos = this.positionCache.getStartPosition(commitEntry.getTxId());
                    LogExtractor.TxPosition newPos = this.positionCache.cacheStartPosition(commitEntry.getTxId(), startEntry, targetLogVersion);
                    this.log.logMessage("Updated tx " + ((LogEntry.Commit)entry).getTxId() + " from " + oldPos + " to " + newPos);
                }
            }
            if (!startEntriesEncountered.containsKey(identifier)) continue;
            LogIoUtils.writeLogEntry(entry, targetLog);
        }
    }

    private LogEntry.Start fetchTransactionBulkFromLogExtractor(long txId, LogBuffer target) throws IOException {
        LogExtractor extractor = new LogExtractor(this.positionCache, this.logLoader, this.monitor, this.commandFactory, txId, txId);
        InMemoryLogBuffer tempBuffer = new InMemoryLogBuffer();
        extractor.extractNext(tempBuffer);
        ByteBuffer localBuffer = LogExtractor.newLogReaderBuffer();
        LogEntry readEntry = null;
        while ((readEntry = LogIoUtils.readEntry(localBuffer, tempBuffer, this.commandFactory)) != null && !(readEntry instanceof LogEntry.Commit)) {
            LogIoUtils.writeLogEntry(readEntry, target);
        }
        return extractor.getLastStartEntry();
    }
}

