/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

public enum BufferNumberPutter {
    BYTE(8){

        @Override
        public void put(ByteBuffer buffer, Number value) {
            buffer.put(value.byteValue());
        }

        @Override
        public void put(LogBuffer buffer, Number value) throws IOException {
            buffer.put(value.byteValue());
        }
    }
    ,
    SHORT(16){

        @Override
        public void put(ByteBuffer buffer, Number value) {
            buffer.putShort(value.shortValue());
        }

        @Override
        public void put(LogBuffer buffer, Number value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    INT(32){

        @Override
        public void put(ByteBuffer buffer, Number value) {
            buffer.putInt(value.intValue());
        }

        @Override
        public void put(LogBuffer buffer, Number value) throws IOException {
            buffer.putInt(value.intValue());
        }
    }
    ,
    LONG(64){

        @Override
        public void put(ByteBuffer buffer, Number value) {
            buffer.putLong(value.longValue());
        }

        @Override
        public void put(LogBuffer buffer, Number value) throws IOException {
            buffer.putLong(value.longValue());
        }
    }
    ,
    FLOAT(32){

        @Override
        public void put(ByteBuffer buffer, Number value) {
            buffer.putFloat(value.floatValue());
        }

        @Override
        public void put(LogBuffer buffer, Number value) throws IOException {
            buffer.putFloat(value.floatValue());
        }
    }
    ,
    DOUBLE(64){

        @Override
        public void put(ByteBuffer buffer, Number value) {
            buffer.putDouble(value.doubleValue());
        }

        @Override
        public void put(LogBuffer buffer, Number value) throws IOException {
            buffer.putDouble(value.doubleValue());
        }
    };

    private final int size;

    private BufferNumberPutter(int size) {
        this.size = size / 8;
    }

    public int size() {
        return this.size;
    }

    public abstract void put(ByteBuffer var1, Number var2);

    public abstract void put(LogBuffer var1, Number var2) throws IOException;
}

