/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;

public abstract class KernelData {
    public static final GraphDatabaseSetting<String> forced_id = GraphDatabaseSettings.forced_kernel_id;
    private static final Map<String, KernelData> instances = new HashMap<String, KernelData>();
    private final String instanceId;
    private final Config configuration;

    private static synchronized String newInstance(KernelData instance) {
        String instanceId = instance.configuration.get(forced_id);
        if (instanceId == null) {
            instanceId = "";
        }
        if ((instanceId = instanceId.trim()).equals("")) {
            for (int i = 0; i < instances.size() + 1 && instances.containsKey(instanceId = Integer.toString(i)); ++i) {
            }
        }
        if (instances.containsKey(instanceId)) {
            throw new IllegalStateException("There is already a kernel started with " + forced_id.name() + "='" + instanceId + "'.");
        }
        instances.put(instanceId, instance);
        return instanceId;
    }

    private static synchronized void removeInstance(String instanceId) {
        instances.remove(instanceId);
    }

    KernelData(Config configuration) {
        this.configuration = configuration;
        this.instanceId = KernelData.newInstance(this);
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final int hashCode() {
        return this.instanceId.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof KernelData && this.instanceId.equals(((KernelData)obj).instanceId);
    }

    public abstract Version version();

    public Config getConfig() {
        return this.configuration;
    }

    public abstract GraphDatabaseAPI graphDatabase();

    public void shutdown() {
        KernelData.removeInstance(this.instanceId);
    }
}

