/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreUpgrader {
    private Config originalConfig;
    private UpgradeConfiguration upgradeConfiguration;
    private UpgradableDatabase upgradableDatabase;
    private StoreMigrator storeMigrator;
    private DatabaseFiles databaseFiles;
    private StringLogger msgLog;
    private IdGeneratorFactory idGeneratorFactory;
    private FileSystemAbstraction fileSystemAbstraction;

    public StoreUpgrader(Config originalConfig, StringLogger msgLog, UpgradeConfiguration upgradeConfiguration, UpgradableDatabase upgradableDatabase, StoreMigrator storeMigrator, DatabaseFiles databaseFiles, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystemAbstraction) {
        this.msgLog = msgLog;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.originalConfig = originalConfig;
        this.upgradeConfiguration = upgradeConfiguration;
        this.upgradableDatabase = upgradableDatabase;
        this.storeMigrator = storeMigrator;
        this.databaseFiles = databaseFiles;
    }

    public void attemptUpgrade(String storageFileName) {
        this.upgradeConfiguration.checkConfigurationAllowsAutomaticUpgrade();
        this.upgradableDatabase.checkUpgradeable(new File(storageFileName));
        File workingDirectory = new File(storageFileName).getParentFile();
        File upgradeDirectory = new File(workingDirectory, "upgrade");
        File backupDirectory = new File(workingDirectory, "upgrade_backup");
        this.migrateToIsolatedDirectory(storageFileName, upgradeDirectory);
        this.databaseFiles.moveToBackupDirectory(workingDirectory, backupDirectory);
        this.backupMessagesLogLeavingInPlaceForNewDatabaseMessages(workingDirectory, backupDirectory);
        this.databaseFiles.moveToWorkingDirectory(upgradeDirectory, workingDirectory);
    }

    private void backupMessagesLogLeavingInPlaceForNewDatabaseMessages(File workingDirectory, File backupDirectory) {
        try {
            FileUtils.copyFile(new File(workingDirectory, "messages.log"), new File(backupDirectory, "messages.log"));
        }
        catch (IOException e) {
            throw new UnableToUpgradeException(e);
        }
    }

    private void migrateToIsolatedDirectory(String storageFileName, File upgradeDirectory) {
        if (upgradeDirectory.exists()) {
            try {
                FileUtils.deleteRecursively(upgradeDirectory);
            }
            catch (IOException e) {
                throw new UnableToUpgradeException(e);
            }
        }
        upgradeDirectory.mkdir();
        String upgradeFileName = new File(upgradeDirectory, "neostore").getPath();
        HashMap<String, String> upgradeConfig = new HashMap<String, String>(this.originalConfig.getParams());
        upgradeConfig.put("neo_store", upgradeFileName);
        Config upgradeConfiguration = new Config(upgradeConfig);
        NeoStore neoStore = new StoreFactory(upgradeConfiguration, this.idGeneratorFactory, new DefaultWindowPoolFactory(), this.fileSystemAbstraction, StringLogger.DEV_NULL, null).createNeoStore(upgradeFileName);
        try {
            this.storeMigrator.migrate(new LegacyStore(storageFileName, StringLogger.DEV_NULL), neoStore);
        }
        catch (IOException e) {
            throw new UnableToUpgradeException(e);
        }
        finally {
            neoStore.close();
        }
    }

    public static class UnableToUpgradeException
    extends RuntimeException {
        public UnableToUpgradeException(Exception cause) {
            super(cause);
        }

        public UnableToUpgradeException(String message) {
            super(message);
        }
    }
}

