/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.AbstractAutoIndexerImpl;
import org.neo4j.kernel.IndexManagerImpl;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.NodeManager;

class RelationshipAutoIndexerImpl
extends AbstractAutoIndexerImpl<Relationship>
implements RelationshipAutoIndexer {
    static final String RELATIONSHIP_AUTO_INDEX = "relationship_auto_index";
    private Config config;
    private IndexManagerImpl indexManager;
    private NodeManager nodeManager;

    public RelationshipAutoIndexerImpl(Config config, IndexManagerImpl indexManager, NodeManager nodeManager) {
        this.config = config;
        this.indexManager = indexManager;
        this.nodeManager = nodeManager;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() {
        this.setEnabled(this.config.get(Configuration.relationship_auto_indexing));
        this.propertyKeysToInclude.addAll(this.parseConfigList(this.config.get(Configuration.relationship_keys_indexable)));
    }

    @Override
    public void stop() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    protected RelationshipIndex getIndexInternal() {
        return this.indexManager.getOrCreateRelationshipIndex(RELATIONSHIP_AUTO_INDEX, null);
    }

    @Override
    public ReadableRelationshipIndex getAutoIndex() {
        return this.getIndexInternal();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.nodeManager.addRelationshipPropertyTracker(this);
        } else {
            this.nodeManager.removeRelationshipPropertyTracker(this);
        }
    }

    static class RelationshipReadOnlyIndexToIndexAdapter
    extends AbstractAutoIndexerImpl.ReadOnlyIndexToIndexAdapter<Relationship>
    implements RelationshipIndex {
        private final ReadableRelationshipIndex delegate;

        public RelationshipReadOnlyIndexToIndexAdapter(ReadableRelationshipIndex delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return this.delegate.get(key, valueOrNull, startNodeOrNull, endNodeOrNull);
        }

        @Override
        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return this.delegate.query(key, queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull);
        }

        @Override
        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return this.delegate.query(queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull);
        }
    }

    public static abstract class Configuration {
        public static final Setting<Boolean> relationship_auto_indexing = GraphDatabaseSettings.relationship_auto_indexing;
        public static final Setting<String> relationship_keys_indexable = GraphDatabaseSettings.relationship_keys_indexable;
    }
}

