/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class LifeSupport
implements Lifecycle {
    List<LifecycleInstance> instances = new ArrayList<LifecycleInstance>();
    LifecycleStatus status = LifecycleStatus.NONE;
    List<LifecycleListener> listeners = new ArrayList<LifecycleListener>();

    @Override
    public synchronized void init() throws LifecycleException {
        if (this.status == LifecycleStatus.NONE) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.INITIALIZING);
            for (LifecycleInstance instance : this.instances) {
                try {
                    instance.init();
                }
                catch (LifecycleException e) {
                    this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPED);
                    try {
                        this.shutdown();
                    }
                    catch (LifecycleException e1) {
                        throw this.causedBy(e1, e);
                    }
                    throw e;
                }
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPED);
        }
    }

    @Override
    public synchronized void start() throws LifecycleException {
        this.init();
        if (this.status == LifecycleStatus.STOPPED) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTING);
            for (LifecycleInstance instance : this.instances) {
                try {
                    instance.start();
                }
                catch (LifecycleException e) {
                    this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTED);
                    try {
                        this.stop();
                    }
                    catch (LifecycleException e1) {
                        throw this.causedBy(e1, e);
                    }
                    throw e;
                }
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTED);
        }
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (this.status == LifecycleStatus.STARTED) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPING);
            LifecycleException ex = null;
            for (int i = this.instances.size() - 1; i >= 0; --i) {
                LifecycleInstance lifecycleInstance = this.instances.get(i);
                try {
                    lifecycleInstance.stop();
                    continue;
                }
                catch (LifecycleException e) {
                    ex = this.causedBy(e, ex);
                }
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPED);
            if (ex != null) {
                throw ex;
            }
        }
    }

    @Override
    public synchronized void shutdown() throws LifecycleException {
        LifecycleException ex = null;
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            ex = e;
        }
        if (this.status == LifecycleStatus.STOPPED) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.SHUTTING_DOWN);
            for (int i = this.instances.size() - 1; i >= 0; --i) {
                LifecycleInstance lifecycleInstance = this.instances.get(i);
                try {
                    lifecycleInstance.shutdown();
                    continue;
                }
                catch (LifecycleException e) {
                    ex = this.causedBy(e, ex);
                }
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.SHUTDOWN);
            if (ex != null) {
                throw ex;
            }
        }
    }

    public synchronized void restart(Lifecycle instance) throws LifecycleException, IllegalArgumentException {
        if (this.status == LifecycleStatus.STARTED) {
            int i;
            boolean foundRestartingInstance = false;
            ArrayList<LifecycleInstance> restartingInstances = new ArrayList<LifecycleInstance>();
            for (LifecycleInstance lifecycleInstance : this.instances) {
                if (lifecycleInstance.instance == instance) {
                    foundRestartingInstance = true;
                }
                if (!foundRestartingInstance) continue;
                restartingInstances.add(lifecycleInstance);
            }
            if (!foundRestartingInstance) {
                throw new IllegalArgumentException("Instance is not registered");
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPING);
            LifecycleException ex = null;
            for (i = restartingInstances.size() - 1; i >= 0; --i) {
                LifecycleInstance lifecycleInstance = (LifecycleInstance)restartingInstances.get(i);
                try {
                    lifecycleInstance.stop();
                    continue;
                }
                catch (LifecycleException e) {
                    ex = this.causedBy(e, ex);
                }
            }
            if (ex != null) {
                this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTED);
                try {
                    this.stop();
                    throw ex;
                }
                catch (LifecycleException e) {
                    throw this.causedBy(e, ex);
                }
            }
            try {
                for (i = 0; i < restartingInstances.size(); ++i) {
                    LifecycleInstance lifecycle = (LifecycleInstance)restartingInstances.get(i);
                    lifecycle.start();
                }
                this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTED);
            }
            catch (LifecycleException e) {
                this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTED);
                try {
                    this.stop();
                    throw e;
                }
                catch (LifecycleException e1) {
                    throw this.causedBy(e1, e);
                }
            }
        }
    }

    public synchronized <T> T add(T instance) throws LifecycleException {
        if (instance instanceof Lifecycle) {
            LifecycleInstance newInstance = new LifecycleInstance((Lifecycle)instance);
            this.instances.add(newInstance);
            this.bringToState(newInstance);
        }
        return instance;
    }

    public synchronized boolean remove(Object instance) {
        for (int i = 0; i < this.instances.size(); ++i) {
            if (!this.instances.get(i).isInstance(instance)) continue;
            LifecycleInstance lifecycleInstance = this.instances.remove(i);
            lifecycleInstance.shutdown();
            return true;
        }
        return false;
    }

    public synchronized Iterable<Lifecycle> getLifecycleInstances() {
        return Iterables.map(new Function<LifecycleInstance, Lifecycle>(){

            @Override
            public Lifecycle apply(LifecycleInstance lifecycleInstance) {
                return lifecycleInstance.instance;
            }
        }, this.instances);
    }

    public synchronized void clear() {
        for (LifecycleInstance instance : this.instances) {
            instance.shutdown();
        }
        this.instances.clear();
    }

    public synchronized LifecycleStatus getStatus() {
        return this.status;
    }

    public synchronized void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void dump(StringLogger logger) {
        logger.logLongMessage("Lifecycle status:" + this.status.name(), new Visitor<StringLogger.LineLogger>(){

            @Override
            public boolean visit(StringLogger.LineLogger element) {
                for (LifecycleInstance instance : LifeSupport.this.instances) {
                    element.logLine(instance.toString());
                }
                return true;
            }
        }, true);
    }

    private void bringToState(LifecycleInstance instance) throws LifecycleException {
        switch (this.status) {
            case STARTED: {
                instance.start();
                break;
            }
            case STOPPED: {
                instance.init();
                break;
            }
        }
    }

    private LifecycleException causedBy(LifecycleException exception, LifecycleException chainedLifecycleException) {
        if (chainedLifecycleException == null) {
            return exception;
        }
        Throwable current = exception;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        current.initCause(chainedLifecycleException);
        return exception;
    }

    private LifecycleStatus changedStatus(Lifecycle instance, LifecycleStatus oldStatus, LifecycleStatus newStatus) {
        for (LifecycleListener listener : this.listeners) {
            listener.notifyStatusChanged(instance, oldStatus, newStatus);
        }
        return newStatus;
    }

    private class LifecycleInstance
    implements Lifecycle {
        Lifecycle instance;
        LifecycleStatus currentStatus = LifecycleStatus.NONE;

        private LifecycleInstance(Lifecycle instance) {
            this.instance = instance;
        }

        @Override
        public void init() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.NONE) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.INITIALIZING);
                try {
                    this.instance.init();
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPED);
                }
                catch (Throwable e) {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.NONE);
                    throw new LifecycleException(this.instance, LifecycleStatus.NONE, LifecycleStatus.STOPPED, e);
                }
            }
        }

        @Override
        public void start() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.NONE) {
                this.init();
            }
            if (this.currentStatus == LifecycleStatus.STOPPED) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STARTING);
                try {
                    this.instance.start();
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STARTED);
                }
                catch (Throwable e) {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPED);
                    throw new LifecycleException(this.instance, LifecycleStatus.STOPPED, LifecycleStatus.STARTED, e);
                }
            }
        }

        @Override
        public void stop() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.STARTED) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPING);
                try {
                    this.instance.stop();
                }
                catch (Throwable e) {
                    throw new LifecycleException(this.instance, LifecycleStatus.STARTED, LifecycleStatus.STOPPED, e);
                }
                finally {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPED);
                }
            }
        }

        @Override
        public void shutdown() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.STARTED) {
                this.stop();
            }
            if (this.currentStatus == LifecycleStatus.STOPPED) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.SHUTTING_DOWN);
                try {
                    this.instance.shutdown();
                }
                catch (Throwable e) {
                    throw new LifecycleException(this.instance, LifecycleStatus.STOPPED, LifecycleStatus.SHUTTING_DOWN, e);
                }
                finally {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.SHUTDOWN);
                }
            }
        }

        public String toString() {
            return this.instance.toString() + ": " + this.currentStatus.name();
        }

        public boolean isInstance(Object instance) {
            return this.instance == instance;
        }
    }
}

