/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreAccess {
    private final RecordStore<NodeRecord> nodeStore;
    private final RecordStore<RelationshipRecord> relStore;
    private final RecordStore<RelationshipTypeRecord> relTypeStore;
    private final RecordStore<PropertyRecord> propStore;
    private final RecordStore<DynamicRecord> stringStore;
    private final RecordStore<DynamicRecord> arrayStore;
    private final RecordStore<PropertyIndexRecord> propIndexStore;
    private final RecordStore<DynamicRecord> typeNameStore;
    private final RecordStore<DynamicRecord> propKeyStore;
    private boolean closeable;
    private NeoStore neoStore;

    public StoreAccess(InternalAbstractGraphDatabase graphdb) {
        this(StoreAccess.getNeoStoreFrom(graphdb));
    }

    private static NeoStore getNeoStoreFrom(InternalAbstractGraphDatabase graphdb) {
        return graphdb.getXaDataSourceManager().getNeoStoreDataSource().getNeoStore();
    }

    public StoreAccess(NeoStore store) {
        this(store.getNodeStore(), store.getRelationshipStore(), store.getPropertyStore(), store.getRelationshipTypeStore());
        this.neoStore = store;
    }

    public StoreAccess(NodeStore nodeStore, RelationshipStore relStore, PropertyStore propStore, RelationshipTypeStore typeStore) {
        this.nodeStore = this.wrapStore(nodeStore);
        this.relStore = this.wrapStore(relStore);
        this.propStore = this.wrapStore(propStore);
        this.stringStore = this.wrapStore(propStore.getStringStore());
        this.arrayStore = this.wrapStore(propStore.getArrayStore());
        this.relTypeStore = this.wrapStore(typeStore);
        this.propIndexStore = this.wrapStore(propStore.getIndexStore());
        this.typeNameStore = this.wrapStore(typeStore.getNameStore());
        this.propKeyStore = this.wrapStore(propStore.getIndexStore().getNameStore());
    }

    public StoreAccess(String path) {
        this(path, StoreAccess.defaultParams());
    }

    public StoreAccess(FileSystemAbstraction fileSystem, String path) {
        this(fileSystem, path, StoreAccess.defaultParams());
    }

    public StoreAccess(String path, Map<String, String> params) {
        this(new DefaultFileSystemAbstraction(), path, params);
    }

    public StoreAccess(FileSystemAbstraction fileSystem, String path, Map<String, String> params) {
        this(new StoreFactory(new Config(StoreAccess.requiredParams(params, path)), new DefaultIdGeneratorFactory(), new DefaultWindowPoolFactory(), fileSystem, StringLogger.DEV_NULL, new DefaultTxHook()).attemptNewNeoStore(new File(path, "neostore")));
        this.closeable = true;
    }

    private static Map<String, String> requiredParams(Map<String, String> params, String path) {
        params = new HashMap<String, String>(params);
        params.put("neo_store", new File(path, "neostore").getPath());
        return params;
    }

    public NeoStore getRawNeoStore() {
        return this.neoStore;
    }

    public RecordStore<NodeRecord> getNodeStore() {
        return this.nodeStore;
    }

    public RecordStore<RelationshipRecord> getRelationshipStore() {
        return this.relStore;
    }

    public RecordStore<PropertyRecord> getPropertyStore() {
        return this.propStore;
    }

    public RecordStore<DynamicRecord> getStringStore() {
        return this.stringStore;
    }

    public RecordStore<DynamicRecord> getArrayStore() {
        return this.arrayStore;
    }

    public RecordStore<RelationshipTypeRecord> getRelationshipTypeStore() {
        return this.relTypeStore;
    }

    public RecordStore<PropertyIndexRecord> getPropertyIndexStore() {
        return this.propIndexStore;
    }

    public RecordStore<DynamicRecord> getTypeNameStore() {
        return this.typeNameStore;
    }

    public RecordStore<DynamicRecord> getPropertyKeyStore() {
        return this.propKeyStore;
    }

    public final <P extends RecordStore.Processor> P applyToAll(P processor) {
        for (RecordStore<?> store : this.allStores()) {
            this.apply(processor, store);
        }
        return processor;
    }

    protected RecordStore<?>[] allStores() {
        if (this.propStore == null) {
            return new RecordStore[]{this.nodeStore, this.relStore, this.relTypeStore, this.typeNameStore};
        }
        return new RecordStore[]{this.nodeStore, this.relStore, this.propStore, this.stringStore, this.arrayStore, this.relTypeStore, this.propIndexStore, this.typeNameStore, this.propKeyStore};
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return store;
    }

    protected void apply(RecordStore.Processor processor, RecordStore<?> store) {
        processor.applyFiltered(store, RecordStore.IN_USE);
    }

    private static Map<String, String> defaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.nodestore_mapped_memory.name(), "20M");
        params.put(GraphDatabaseSettings.nodestore_propertystore_mapped_memory.name(), "90M");
        params.put(GraphDatabaseSettings.nodestore_propertystore_index_mapped_memory.name(), "1M");
        params.put(GraphDatabaseSettings.nodestore_propertystore_index_mapped_memory.name(), "1M");
        params.put(GraphDatabaseSettings.strings_mapped_memory.name(), "130M");
        params.put(GraphDatabaseSettings.arrays_mapped_memory.name(), "130M");
        params.put(GraphDatabaseSettings.relationshipstore_mapped_memory.name(), "100M");
        if (GraphDatabaseSetting.osIsWindows()) {
            params.put(GraphDatabaseSettings.use_memory_mapped_buffers.name(), "false");
        }
        params.put(GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "true");
        return params;
    }

    public synchronized void close() {
        if (this.closeable) {
            this.closeable = false;
            this.neoStore.close();
        }
    }
}

