/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyRelationshipStoreReader {
    public static final String FROM_VERSION = "RelationshipStore v0.9.9";
    public static final int RECORD_LENGTH = 33;
    private final FileChannel fileChannel;
    private final long maxId;

    public LegacyRelationshipStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 33L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public Iterable<RelationshipRecord> readRelationshipStore() throws IOException {
        final ByteBuffer buffer = ByteBuffer.allocateDirect(33);
        return new Iterable<RelationshipRecord>(){

            @Override
            public Iterator<RelationshipRecord> iterator() {
                return new PrefetchingIterator<RelationshipRecord>(){
                    long id = 0L;

                    @Override
                    protected RelationshipRecord fetchNextOrNull() {
                        RelationshipRecord record = null;
                        while (record == null && this.id <= LegacyRelationshipStoreReader.this.maxId) {
                            boolean inUse;
                            buffer.clear();
                            try {
                                LegacyRelationshipStoreReader.this.fileChannel.read(buffer);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            buffer.flip();
                            long inUseByte = buffer.get();
                            boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
                            if (inUse) {
                                long firstNode = LegacyStore.getUnsignedInt(buffer);
                                long firstNodeMod = (inUseByte & 0xEL) << 31;
                                long secondNode = LegacyStore.getUnsignedInt(buffer);
                                long typeInt = buffer.getInt();
                                long secondNodeMod = (typeInt & 0x70000000L) << 4;
                                int type = (int)(typeInt & 0xFFFFL);
                                record = new RelationshipRecord(this.id, LegacyStore.longFromIntAndMod(firstNode, firstNodeMod), LegacyStore.longFromIntAndMod(secondNode, secondNodeMod), type);
                                record.setInUse(inUse);
                                long firstPrevRel = LegacyStore.getUnsignedInt(buffer);
                                long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
                                record.setFirstPrevRel(LegacyStore.longFromIntAndMod(firstPrevRel, firstPrevRelMod));
                                long firstNextRel = LegacyStore.getUnsignedInt(buffer);
                                long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
                                record.setFirstNextRel(LegacyStore.longFromIntAndMod(firstNextRel, firstNextRelMod));
                                long secondPrevRel = LegacyStore.getUnsignedInt(buffer);
                                long secondPrevRelMod = (typeInt & 0x380000L) << 13;
                                record.setSecondPrevRel(LegacyStore.longFromIntAndMod(secondPrevRel, secondPrevRelMod));
                                long secondNextRel = LegacyStore.getUnsignedInt(buffer);
                                long secondNextRelMod = (typeInt & 0x70000L) << 16;
                                record.setSecondNextRel(LegacyStore.longFromIntAndMod(secondNextRel, secondNextRelMod));
                                long nextProp = LegacyStore.getUnsignedInt(buffer);
                                long nextPropMod = (inUseByte & 0xF0L) << 28;
                                record.setNextProp(LegacyStore.longFromIntAndMod(nextProp, nextPropMod));
                            } else {
                                record = new RelationshipRecord(this.id, -1L, -1L, -1);
                                record.setInUse(false);
                            }
                            ++this.id;
                        }
                        return record;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }
}

