/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockException;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;

public class RagManager
implements Visitor<StringLogger.LineLogger> {
    private final Map<Object, List<Transaction>> resourceMap = new HashMap<Object, List<Transaction>>();
    private final ArrayMap<Transaction, Object> waitingTxMap = new ArrayMap(5, false, true);
    private final TransactionManager tm;
    private final AtomicInteger deadlockCount = new AtomicInteger();

    public RagManager(TransactionManager tm) {
        this.tm = tm;
    }

    long getDeadlockCount() {
        return this.deadlockCount.longValue();
    }

    synchronized void lockAcquired(Object resource, Transaction tx) {
        List<Transaction> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList != null) {
            assert (!lockingTxList.contains(tx));
            lockingTxList.add(tx);
        } else {
            lockingTxList = new LinkedList<Transaction>();
            lockingTxList.add(tx);
            this.resourceMap.put(resource, lockingTxList);
        }
    }

    synchronized void lockReleased(Object resource, Transaction tx) {
        List<Transaction> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList == null) {
            throw new LockException(resource + " not found in resource map");
        }
        if (!lockingTxList.remove(tx)) {
            throw new LockException(tx + "not found in locking tx list");
        }
        if (lockingTxList.size() == 0) {
            this.resourceMap.remove(resource);
        }
    }

    synchronized void stopWaitOn(Object resource, Transaction tx) {
        if (this.waitingTxMap.remove(tx) == null) {
            throw new LockException(tx + " not waiting on " + resource);
        }
    }

    synchronized void checkWaitOn(Object resource, Transaction tx) throws DeadlockDetectedException {
        List<Transaction> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList == null) {
            throw new LockException("Illegal resource[" + resource + "], not found in map");
        }
        if (this.waitingTxMap.get(tx) != null) {
            throw new LockException(tx + " already waiting for resource");
        }
        Iterator<Transaction> itr = lockingTxList.iterator();
        LinkedList<Transaction> checkedTransactions = new LinkedList<Transaction>();
        Stack<Object> graphStack = new Stack<Object>();
        graphStack.push(resource);
        while (itr.hasNext()) {
            Transaction lockingTx = itr.next();
            if (lockingTx.equals(tx)) continue;
            graphStack.push(lockingTx);
            this.checkWaitOnRecursive(lockingTx, tx, checkedTransactions, graphStack);
            graphStack.pop();
        }
        this.waitingTxMap.put(tx, resource);
    }

    private synchronized void checkWaitOnRecursive(Transaction lockingTx2, Transaction waitingTx, List<Transaction> checkedTransactions, Stack<Object> graphStack) throws DeadlockDetectedException {
        if (lockingTx2.equals(waitingTx)) {
            StringBuffer circle = null;
            Object resource = null;
            do {
                lockingTx2 = (Transaction)graphStack.pop();
                resource = graphStack.pop();
                if (circle == null) {
                    circle = new StringBuffer();
                    circle.append(lockingTx2 + " <-[:HELD_BY]- " + resource);
                    continue;
                }
                circle.append(" <-[:WAITING_FOR]- " + lockingTx2 + " <-[:HELD_BY]- " + resource);
            } while (!graphStack.isEmpty());
            this.deadlockCount.incrementAndGet();
            throw new DeadlockDetectedException(waitingTx + " can't wait on resource " + resource + " since => " + circle);
        }
        checkedTransactions.add(lockingTx2);
        Object resource = this.waitingTxMap.get(lockingTx2);
        if (resource != null) {
            graphStack.push(resource);
            List<Transaction> lockingTxList = this.resourceMap.get(resource);
            if (lockingTxList != null) {
                for (Transaction lockingTx2 : lockingTxList) {
                    if (checkedTransactions.contains(lockingTx2)) continue;
                    graphStack.push(lockingTx2);
                    this.checkWaitOnRecursive(lockingTx2, waitingTx, checkedTransactions, graphStack);
                    graphStack.pop();
                }
            }
            graphStack.pop();
        }
    }

    @Override
    public synchronized boolean visit(StringLogger.LineLogger logger) {
        logger.logLine("Waiting list: ");
        Iterator<Transaction> transactions = this.waitingTxMap.keySet().iterator();
        if (!transactions.hasNext()) {
            logger.logLine("No transactions waiting on resources");
        } else {
            logger.logLine("");
        }
        while (transactions.hasNext()) {
            Transaction tx = transactions.next();
            logger.logLine("" + tx + "->" + this.waitingTxMap.get(tx));
        }
        logger.logLine("Resource lock list: ");
        Iterator<Object> resources = this.resourceMap.keySet().iterator();
        if (!resources.hasNext()) {
            logger.logLine("No locked resources found");
        } else {
            logger.logLine("");
        }
        while (resources.hasNext()) {
            Object resource = resources.next();
            logger.logLine("" + resource + "->");
            Iterator<Transaction> itr = this.resourceMap.get(resource).iterator();
            if (!itr.hasNext()) {
                logger.logLine(" Error empty list found");
            }
            while (itr.hasNext()) {
                logger.logLine("" + itr.next());
                if (itr.hasNext()) {
                    logger.logLine(",");
                    continue;
                }
                logger.logLine("");
            }
        }
        return true;
    }

    Transaction getCurrentTransaction() {
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Could not get current transaction.", e);
        }
    }
}

