/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.BufferedFileChannel;

public class LogExtractor {
    private static final String[] ACTIVE_POSTFIXES = new String[]{".1", ".2"};
    private static final int CACHE_FIND_THRESHOLD = 10000;
    private final ByteBuffer localBuffer = LogExtractor.newLogReaderBuffer();
    private ReadableByteChannel source;
    private final LogEntryCollector collector;
    private long version;
    private LogEntry.Commit lastCommitEntry;
    private LogEntry.Commit previousCommitEntry;
    private final long startTxId;
    private long nextExpectedTxId;
    private int counter;
    private final LogPositionCache cache;
    private final LogLoader logLoader;
    private final XaCommandFactory commandFactory;
    public static final XaCommandFactory NIONEO_COMMAND_FACTORY = new XaCommandFactory(){

        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(null, byteChannel, buffer);
        }
    };

    public static ByteBuffer newLogReaderBuffer() {
        return ByteBuffer.allocate(713);
    }

    public LogExtractor(LogPositionCache cache, LogLoader logLoader, XaCommandFactory commandFactory, long startTxId, long endTxIdHint) throws IOException {
        TxPosition earliestPosition;
        this.cache = cache;
        this.logLoader = logLoader;
        this.commandFactory = commandFactory;
        this.startTxId = startTxId;
        this.nextExpectedTxId = startTxId;
        long diff = endTxIdHint - startTxId + 1L;
        if (diff < 10000L && (earliestPosition = this.getEarliestStartPosition(startTxId, endTxIdHint)) != null) {
            this.version = earliestPosition.version;
            this.source = logLoader.getLogicalLogOrMyselfCommitted(this.version, earliestPosition.position);
        }
        if (this.source == null) {
            this.version = this.findLogContainingTxId(startTxId)[0];
            this.source = logLoader.getLogicalLogOrMyselfCommitted(this.version, 0L);
            XaLogicalLog.readAndAssertLogHeader(this.localBuffer, this.source, this.version);
        }
        this.collector = new KnownTxIdCollector(startTxId);
    }

    private TxPosition getEarliestStartPosition(long startTxId, long endTxIdHint) {
        TxPosition earliest = null;
        for (long txId = startTxId; txId <= endTxIdHint; ++txId) {
            TxPosition position = this.cache.positionOf(txId);
            if (position == null) {
                return null;
            }
            if (earliest != null && !position.earlierThan(earliest)) continue;
            earliest = position;
        }
        return earliest;
    }

    public long extractNext(LogBuffer target) throws IOException {
        try {
            while (this.version <= this.logLoader.getHighestLogVersion()) {
                long result = this.collectNextFromCurrentSource(target);
                if (result != -1L) {
                    if (this.previousCommitEntry != null && result == this.previousCommitEntry.getTxId()) continue;
                    if (result != this.nextExpectedTxId) {
                        throw new RuntimeException("Expected txId " + this.nextExpectedTxId + ", but got " + result + " (starting from " + this.startTxId + ")" + " " + this.counter + ", " + this.previousCommitEntry + ", " + this.lastCommitEntry);
                    }
                    ++this.nextExpectedTxId;
                    ++this.counter;
                    return result;
                }
                if (this.version >= this.logLoader.getHighestLogVersion()) break;
                this.continueInNextLog();
            }
            return -1L;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.cache.clear();
            throw Exceptions.launderedException(e);
        }
    }

    private void continueInNextLog() throws IOException {
        this.ensureSourceIsClosed();
        this.source = this.logLoader.getLogicalLogOrMyselfCommitted(++this.version, 0L);
        XaLogicalLog.readAndAssertLogHeader(this.localBuffer, this.source, this.version);
    }

    private long collectNextFromCurrentSource(LogBuffer target) throws IOException {
        LogEntry entry = null;
        while (this.collector.hasInFutureQueue() || (entry = LogIoUtils.readEntry(this.localBuffer, this.source, this.commandFactory)) != null) {
            LogEntry foundEntry = this.collector.collect(entry, target);
            if (foundEntry == null) continue;
            this.previousCommitEntry = this.lastCommitEntry;
            LogIoUtils.writeLogEntry(new LogEntry.Done(this.collector.getIdentifier()), target);
            this.lastCommitEntry = (LogEntry.Commit)foundEntry;
            return this.lastCommitEntry.getTxId();
        }
        return -1L;
    }

    public void close() {
        this.ensureSourceIsClosed();
    }

    protected void finalize() throws Throwable {
        this.ensureSourceIsClosed();
    }

    private void ensureSourceIsClosed() {
        try {
            if (this.source != null) {
                this.source.close();
                this.source = null;
            }
        }
        catch (IOException e) {
            System.out.println("Couldn't close logical after extracting transactions from it");
            e.printStackTrace();
        }
    }

    public LogEntry.Commit getLastCommitEntry() {
        return this.lastCommitEntry;
    }

    public long getLastTxChecksum() {
        return this.getLastStartEntry().getChecksum();
    }

    public LogEntry.Start getLastStartEntry() {
        return this.collector.getLastStartEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findLogContainingTxId(long txId) throws IOException {
        long version;
        long committedTx = 1L;
        for (version = this.logLoader.getHighestLogVersion(); version >= 0L; --version) {
            Long cachedLastTx = this.cache.getHeader(version);
            if (cachedLastTx != null) {
                committedTx = cachedLastTx;
            } else {
                ReadableByteChannel logChannel = this.logLoader.getLogicalLogOrMyselfCommitted(version, 0L);
                try {
                    ByteBuffer buf = ByteBuffer.allocate(16);
                    long[] header = XaLogicalLog.readAndAssertLogHeader(buf, logChannel, version);
                    committedTx = header[1];
                    this.cache.putHeader(version, committedTx);
                }
                finally {
                    logChannel.close();
                }
            }
            if (committedTx < txId) break;
        }
        if (version == -1L) {
            throw new NoSuchTransactionException(txId, "started at " + this.logLoader.getHighestLogVersion() + " searching backwards");
        }
        return new long[]{version, committedTx};
    }

    public static LogExtractor from(FileSystemAbstraction fileSystem, File storeDir) throws IOException {
        return LogExtractor.from(fileSystem, storeDir, NIONEO_COMMAND_FACTORY);
    }

    public static LogExtractor from(FileSystemAbstraction fileSystem, File storeDir, long startTxId) throws IOException {
        return LogExtractor.from(fileSystem, storeDir, NIONEO_COMMAND_FACTORY, startTxId);
    }

    public static LogExtractor from(FileSystemAbstraction fileSystem, File storeDir, XaCommandFactory commandFactory) throws IOException {
        return LogExtractor.from(fileSystem, storeDir, commandFactory, 2L);
    }

    public static LogExtractor from(final FileSystemAbstraction fileSystem, final File storeDir, XaCommandFactory commandFactory, long startTxId) throws IOException {
        LogLoader loader = new LogLoader(){
            private final Map<Long, File> activeLogFiles;
            private final long highestLogVersion;
            {
                this.activeLogFiles = this.getActiveLogs(storeDir);
                this.highestLogVersion = Math.max(XaLogicalLog.getHighestHistoryLogVersion(fileSystem, storeDir, "nioneo_logical.log"), this.maxKey(this.activeLogFiles));
            }

            @Override
            public ReadableByteChannel getLogicalLogOrMyselfCommitted(long version, long position) throws IOException {
                File name = this.getFileName(version);
                if (!fileSystem.fileExists(name) && (name = this.activeLogFiles.get(version)) == null) {
                    throw new NoSuchLogVersionException(version, name.getPath());
                }
                FileChannel channel = fileSystem.open(name, "r");
                channel.position(position);
                return new BufferedFileChannel(channel);
            }

            private long maxKey(Map<Long, File> activeLogFiles) {
                long max = 0L;
                for (Long key : activeLogFiles.keySet()) {
                    max = Math.max(max, key);
                }
                return max;
            }

            private Map<Long, File> getActiveLogs(File storeDir2) throws IOException {
                HashMap<Long, File> result = new HashMap<Long, File>();
                for (String postfix : ACTIVE_POSTFIXES) {
                    File candidateFile = new File(storeDir2, "nioneo_logical.log" + postfix);
                    if (!fileSystem.fileExists(candidateFile)) continue;
                    long[] header = LogIoUtils.readLogHeader(fileSystem, candidateFile);
                    result.put(header[0], candidateFile);
                }
                return result;
            }

            @Override
            public File getFileName(long version) {
                return new File(storeDir, "nioneo_logical.log.v" + version);
            }

            @Override
            public long getHighestLogVersion() {
                return this.highestLogVersion;
            }

            @Override
            public Long getFirstCommittedTxId(long version) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Long getFirstStartRecordTimestamp(long version) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getLastCommittedTxId() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return this.getClass().getSimpleName() + "[" + storeDir + "]";
            }
        };
        return new LogExtractor(new LogPositionCache(), loader, commandFactory, startTxId, Long.MAX_VALUE);
    }

    public static class TxPosition {
        final long version;
        final int masterId;
        final int identifier;
        final long position;
        final long checksum;

        public TxPosition(long version, int masterId, int identifier, long position, long checksum) {
            this.version = version;
            this.masterId = masterId;
            this.identifier = identifier;
            this.position = position;
            this.checksum = checksum;
        }

        public boolean earlierThan(TxPosition other) {
            if (this.version < other.version) {
                return true;
            }
            if (this.version > other.version) {
                return false;
            }
            return this.position < other.position;
        }

        public String toString() {
            return "TxPosition[version:" + this.version + ", pos:" + this.position + "]";
        }
    }

    private static class KnownTxIdCollector
    implements LogEntryCollector {
        private final Map<Integer, List<LogEntry>> transactions = new HashMap<Integer, List<LogEntry>>();
        private final long startTxId;
        private int identifier;
        private final Map<Long, List<LogEntry>> futureQueue = new HashMap<Long, List<LogEntry>>();
        private long nextExpectedTxId;
        private LogEntry.Start lastStartEntry;

        KnownTxIdCollector(long startTxId) {
            this.startTxId = startTxId;
            this.nextExpectedTxId = startTxId;
        }

        @Override
        public int getIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean hasInFutureQueue() {
            return this.futureQueue.containsKey(this.nextExpectedTxId);
        }

        @Override
        public LogEntry.Start getLastStartEntry() {
            return this.lastStartEntry;
        }

        @Override
        public LogEntry collect(LogEntry entry, LogBuffer target) throws IOException {
            if (this.futureQueue.containsKey(this.nextExpectedTxId)) {
                long txId = this.nextExpectedTxId++;
                List<LogEntry> list = this.futureQueue.remove(txId);
                this.lastStartEntry = (LogEntry.Start)list.get(0);
                this.writeToBuffer(list, target);
                return this.commitEntryOf(txId, list);
            }
            if (entry instanceof LogEntry.Start) {
                LinkedList<LogEntry> list = new LinkedList<LogEntry>();
                list.add(entry);
                this.transactions.put(entry.getIdentifier(), list);
            } else {
                if (entry instanceof LogEntry.Commit) {
                    long commitTxId = ((LogEntry.Commit)entry).getTxId();
                    if (commitTxId < this.startTxId) {
                        return null;
                    }
                    this.identifier = entry.getIdentifier();
                    List<LogEntry> entries = this.transactions.get(this.identifier);
                    if (entries == null) {
                        return null;
                    }
                    entries.add(entry);
                    if (this.nextExpectedTxId != this.startTxId && commitTxId < this.nextExpectedTxId) {
                        return null;
                    }
                    if (commitTxId != this.nextExpectedTxId) {
                        this.futureQueue.put(commitTxId, entries);
                        return null;
                    }
                    this.writeToBuffer(entries, target);
                    this.nextExpectedTxId = commitTxId + 1L;
                    this.lastStartEntry = (LogEntry.Start)entries.get(0);
                    return entry;
                }
                if (entry instanceof LogEntry.Command || entry instanceof LogEntry.Prepare) {
                    List<LogEntry> list = this.transactions.get(entry.getIdentifier());
                    if (list != null) {
                        list.add(entry);
                    }
                } else if (entry instanceof LogEntry.Done) {
                    this.transactions.remove(entry.getIdentifier());
                } else {
                    throw new RuntimeException("Unknown entry: " + entry);
                }
            }
            return null;
        }

        private LogEntry commitEntryOf(long txId, List<LogEntry> list) throws IOException {
            for (LogEntry entry : list) {
                if (!(entry instanceof LogEntry.Commit)) continue;
                return entry;
            }
            throw new NoSuchTransactionException(txId, "No commit entry in " + list);
        }

        private void writeToBuffer(List<LogEntry> entries, LogBuffer target) throws IOException {
            if (target != null) {
                for (LogEntry entry : entries) {
                    LogIoUtils.writeLogEntry(entry, target);
                }
            }
        }
    }

    private static interface LogEntryCollector {
        public LogEntry collect(LogEntry var1, LogBuffer var2) throws IOException;

        public LogEntry.Start getLastStartEntry();

        public boolean hasInFutureQueue();

        public int getIdentifier();
    }

    public static interface LogLoader {
        public ReadableByteChannel getLogicalLogOrMyselfCommitted(long var1, long var3) throws IOException;

        public long getHighestLogVersion();

        public File getFileName(long var1);

        public Long getFirstCommittedTxId(long var1);

        public long getLastCommittedTxId();

        public Long getFirstStartRecordTimestamp(long var1) throws IOException;
    }

    public static class LogPositionCache {
        private final LruCache<Long, TxPosition> txStartPositionCache = new LruCache("Tx start position cache", 10000);
        private final LruCache<Long, Long> logHeaderCache = new LruCache("Log header cache", 1000);

        public void clear() {
            this.logHeaderCache.clear();
            this.txStartPositionCache.clear();
        }

        public TxPosition positionOf(long txId) {
            return this.txStartPositionCache.get(txId);
        }

        public void putHeader(long logVersion, long previousLogLastCommittedTx) {
            this.logHeaderCache.put(logVersion, previousLogLastCommittedTx);
        }

        public Long getHeader(long logVersion) {
            return this.logHeaderCache.get(logVersion);
        }

        public void putStartPosition(long txId, TxPosition position) {
            this.txStartPositionCache.put(txId, position);
        }

        public TxPosition getStartPosition(long txId) {
            return this.txStartPositionCache.get(txId);
        }

        public synchronized TxPosition cacheStartPosition(long txId, LogEntry.Start startEntry, long logVersion) {
            if (startEntry.getStartPosition() == -1L) {
                throw new RuntimeException("StartEntry.position is " + startEntry.getStartPosition());
            }
            TxPosition result = new TxPosition(logVersion, startEntry.getMasterId(), startEntry.getIdentifier(), startEntry.getStartPosition(), startEntry.getChecksum());
            this.putStartPosition(txId, result);
            return result;
        }
    }
}

