/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreLocker {
    public static final String STORE_LOCK_FILENAME = "store_lock";
    private final Config configuration;
    private final StringLogger logger;
    private final FileSystemAbstraction fileSystemAbstraction;
    private FileLock storeLockFileLock;
    private FileChannel storeLockFileChannel;

    public StoreLocker(Config configuration, FileSystemAbstraction fileSystemAbstraction, StringLogger logger) {
        this.configuration = configuration;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.logger = logger;
    }

    public boolean lock(File storeDir) {
        File storeLockFile = new File(storeDir, STORE_LOCK_FILENAME);
        try {
            if (!this.fileSystemAbstraction.fileExists(storeLockFile)) {
                if (this.configuration.get(GraphDatabaseSettings.read_only).booleanValue()) {
                    this.logger.warn("Unable to lock store as store dir does not exist and instance is in read-only mode");
                    return false;
                }
                this.fileSystemAbstraction.autoCreatePath(storeLockFile.getParentFile());
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to create path for store dir: " + storeDir, e);
            return false;
        }
        try {
            this.storeLockFileChannel = this.fileSystemAbstraction.open(storeLockFile, "rw");
            this.storeLockFileLock = this.fileSystemAbstraction.tryLock(storeLockFile, this.storeLockFileChannel);
            return this.storeLockFileLock != null;
        }
        catch (OverlappingFileLockException e) {
            this.logger.warn("Unable to obtain lock on store lock file: " + storeLockFile, e);
            return false;
        }
        catch (IOException e) {
            this.logger.warn("Unable to obtain lock on store lock file: " + storeLockFile, e);
            return false;
        }
    }

    public void release() throws IOException {
        if (this.storeLockFileLock != null) {
            this.storeLockFileLock.release();
            this.storeLockFileLock = null;
        }
        if (this.storeLockFileChannel != null) {
            this.storeLockFileChannel.close();
            this.storeLockFileChannel = null;
        }
    }
}

