/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;

public class ConstraintEvaluatingStatementContext
extends CompositeStatementContext {
    private final StatementContext delegate;

    public ConstraintEvaluatingStatementContext(StatementContext delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public long getOrCreateLabelId(String label) throws ConstraintViolationKernelException {
        if (label == null || label.length() == 0) {
            throw new ConstraintViolationKernelException(String.format("%s is not a valid label name. Only non-empty strings are allowed.", label == null ? "null" : "'" + label + "'"));
        }
        return this.delegate.getOrCreateLabelId(label);
    }

    @Override
    public IndexRule addIndexRule(long labelId, long propertyKey) throws ConstraintViolationKernelException {
        for (IndexRule existingRule : IteratorUtil.loop(this.getIndexRules(labelId))) {
            if (existingRule.getPropertyKey() != propertyKey) continue;
            throw new ConstraintViolationKernelException("Property " + propertyKey + " is already indexed for label " + labelId + ".");
        }
        return this.delegate.addIndexRule(labelId, propertyKey);
    }
}

