/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.EntityNotFoundException;
import org.neo4j.kernel.api.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.PropertyNotFoundException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;

public class LockingStatementContext
extends CompositeStatementContext {
    private final LockHolder lockHolder;
    private final StatementContext delegate;

    public LockingStatementContext(StatementContext actual, LockHolder lockHolder) {
        super(actual);
        this.lockHolder = lockHolder;
        this.delegate = actual;
    }

    @Override
    public boolean addLabelToNode(long labelId, long nodeId) {
        this.lockHolder.acquireNodeWriteLock(nodeId);
        return this.delegate.addLabelToNode(labelId, nodeId);
    }

    @Override
    public boolean removeLabelFromNode(long labelId, long nodeId) {
        this.lockHolder.acquireNodeWriteLock(nodeId);
        return this.delegate.removeLabelFromNode(labelId, nodeId);
    }

    @Override
    public IndexRule addIndexRule(long labelId, long propertyKey) throws ConstraintViolationKernelException {
        this.lockHolder.acquireSchemaWriteLock();
        return this.delegate.addIndexRule(labelId, propertyKey);
    }

    @Override
    public void dropIndexRule(IndexRule indexRule) throws ConstraintViolationKernelException {
        this.lockHolder.acquireSchemaWriteLock();
        this.delegate.dropIndexRule(indexRule);
    }

    @Override
    public <K, V> V getOrCreateFromSchemaState(K key, Function<K, V> creator) {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.getOrCreateFromSchemaState(key, creator);
    }

    @Override
    public <K> boolean schemaStateContains(K key) {
        this.lockHolder.acquireSchemaReadLock();
        return super.schemaStateContains(key);
    }

    @Override
    public Iterator<IndexRule> getIndexRules(long labelId) {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.getIndexRules(labelId);
    }

    @Override
    public Iterator<IndexRule> getIndexRules() {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.getIndexRules();
    }

    @Override
    public Object getNodePropertyValue(long nodeId, long propertyId) throws PropertyKeyIdNotFoundException, PropertyNotFoundException, EntityNotFoundException {
        this.lockHolder.acquireNodeReadLock(nodeId);
        return super.getNodePropertyValue(nodeId, propertyId);
    }
}

