/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.KernelException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;

public class FlippableIndexProxy
implements IndexProxy {
    private boolean closed;
    private static final Callable<Void> NO_OP = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            return null;
        }
    };
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private IndexProxyFactory flipTarget;
    private IndexProxy delegate;

    public FlippableIndexProxy() {
        this(null);
    }

    public FlippableIndexProxy(IndexProxy originalDelegate) {
        this.delegate = originalDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.start();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Iterable<NodePropertyUpdate> updates) throws IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.update(updates);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(Iterable<NodePropertyUpdate> updates) throws IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.recover(updates);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> drop() throws IOException {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            Future<Void> future = this.delegate.drop();
            return future;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() throws IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.force();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDescriptor getDescriptor() {
        this.lock.readLock().lock();
        try {
            IndexDescriptor indexDescriptor = this.delegate.getDescriptor();
            return indexDescriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalIndexState getState() {
        this.lock.readLock().lock();
        try {
            InternalIndexState internalIndexState = this.delegate.getState();
            return internalIndexState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() throws IOException {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            Future<Void> future = this.delegate.close();
            return future;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        this.lock.readLock().lock();
        try {
            IndexReader indexReader = this.delegate.newReader();
            return indexReader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public IndexProxy getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlipTarget(IndexProxyFactory flipTarget) {
        this.lock.writeLock().lock();
        try {
            this.flipTarget = flipTarget;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void flip() {
        try {
            this.flip(NO_OP);
        }
        catch (FlipFailedKernelException e) {
            throw new ThisShouldNotHappenError("Mattias", "Flipping without a particular action should not fail this way");
        }
    }

    public void flip(Callable<Void> actionDuringFlip) throws FlipFailedKernelException {
        this.flip(actionDuringFlip, this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(Callable<Void> actionDuringFlip, IndexProxy failureFlipTarget) throws FlipFailedKernelException {
        this.lock.writeLock().lock();
        try {
            this.assertStillOpenForBusiness();
            try {
                actionDuringFlip.call();
                this.delegate = this.flipTarget.create();
            }
            catch (Exception e) {
                this.delegate = failureFlipTarget;
                throw new FlipFailedKernelException("Failed to transition index to new context, see nested exception.", e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " -> " + this.delegate + "[target:" + this.flipTarget + "]";
    }

    private void assertStillOpenForBusiness() {
        if (this.closed) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been closed. No more interactions allowed");
        }
    }

    public static final class FlipFailedKernelException
    extends KernelException {
        public FlipFailedKernelException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

