/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ValueGetter;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class IndexPopulationJob
implements Runnable {
    private final IndexingService.IndexStoreView storeView;
    private final Queue<NodePropertyUpdate> queue = new ConcurrentLinkedQueue<NodePropertyUpdate>();
    private final IndexDescriptor descriptor;
    private final IndexPopulator populator;
    private final FlippableIndexProxy flipper;
    private final UpdateableSchemaState updateableSchemaState;
    private final StringLogger log;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private volatile IndexingService.StoreScan storeScan;
    private volatile boolean cancelled;

    public IndexPopulationJob(IndexDescriptor descriptor, IndexPopulator populator, FlippableIndexProxy flipper, IndexingService.IndexStoreView storeView, UpdateableSchemaState updateableSchemaState, Logging logging) {
        this.descriptor = descriptor;
        this.populator = populator;
        this.flipper = flipper;
        this.storeView = storeView;
        this.updateableSchemaState = updateableSchemaState;
        this.log = logging.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean success = false;
        try {
            this.log.info(String.format("Index population started for label id %d on property id %d", this.descriptor.getLabelId(), this.descriptor.getPropertyKeyId()));
            this.populator.create();
            this.indexAllNodes();
            if (this.cancelled) {
                return;
            }
            Callable<Void> duringFlip = new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    IndexPopulationJob.this.populateFromQueueIfAvailable(Long.MAX_VALUE);
                    IndexPopulationJob.this.populator.close(true);
                    IndexPopulationJob.this.updateableSchemaState.flush();
                    return null;
                }
            };
            FailedIndexProxy failureTarget = new FailedIndexProxy(this.descriptor, this.populator);
            this.flipper.flip(duringFlip, failureTarget);
            success = true;
            this.log.info(String.format("Index population completed for label id %d on property id %d, index is now online.", this.descriptor.getLabelId(), this.descriptor.getPropertyKeyId()));
            return;
        }
        catch (Throwable t) {
            this.log.error("Failed to populate index.", t);
            this.flipper.setFlipTarget(IndexingService.singleProxy(new FailedIndexProxy(this.descriptor, this.populator, t)));
            this.flipper.flip();
            return;
        }
        finally {
            try {
                if (!success) {
                    this.populator.close(false);
                }
            }
            catch (Throwable e) {
                this.log.warn("Unable to close failed populator", e);
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }

    private void indexAllNodes() {
        this.storeScan = this.storeView.visitNodesWithPropertyAndLabel(this.descriptor, new Visitor<Pair<Long, Object>>(){

            @Override
            public boolean visit(Pair<Long, Object> element) {
                IndexPopulationJob.this.populator.add(element.first(), element.other());
                IndexPopulationJob.this.populateFromQueueIfAvailable(element.first());
                return false;
            }
        });
        this.storeScan.run();
    }

    private void populateFromQueueIfAvailable(final long highestIndexedNodeId) {
        if (!this.queue.isEmpty()) {
            Predicate<NodePropertyUpdate> hasBeenIndexed = new Predicate<NodePropertyUpdate>(){

                @Override
                public boolean accept(NodePropertyUpdate item) {
                    return item.getNodeId() <= highestIndexedNodeId;
                }
            };
            this.populator.update(Iterables.filter(hasBeenIndexed, this.queue));
        }
    }

    public Future<Void> cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
        }
        return FutureAdapter.latchGuardedValue(ValueGetter.NO_VALUE, this.doneSignal);
    }

    public void update(Iterable<NodePropertyUpdate> updates) {
        for (NodePropertyUpdate update : updates) {
            this.queue.add(update);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.populator + ",descriptor:" + this.descriptor + "]";
    }
}

