/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.logging.Logging;

public class PopulatingIndexProxy
implements IndexProxy {
    private final JobScheduler scheduler;
    private final IndexDescriptor descriptor;
    private final IndexPopulationJob job;

    public PopulatingIndexProxy(JobScheduler scheduler, IndexDescriptor descriptor, IndexPopulator writer, FlippableIndexProxy flipper, IndexingService.IndexStoreView storeView, UpdateableSchemaState updateableSchemaState, Logging logging) {
        this.scheduler = scheduler;
        this.descriptor = descriptor;
        this.job = new IndexPopulationJob(descriptor, writer, flipper, storeView, updateableSchemaState, logging);
    }

    @Override
    public void start() {
        this.scheduler.submit(this.job);
    }

    @Override
    public void update(Iterable<NodePropertyUpdate> updates) {
        this.job.update(updates);
    }

    @Override
    public void recover(Iterable<NodePropertyUpdate> updates) throws IOException {
        throw new UnsupportedOperationException("Recovered updates shouldn't reach this place");
    }

    @Override
    public Future<Void> drop() {
        return this.job.cancel();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public void force() {
    }

    @Override
    public Future<Void> close() {
        return this.job.cancel();
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException(this.descriptor + " is still populating");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + this.job + "]";
    }
}

