/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.core.KeyCreator;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public abstract class IsolatedTransactionKeyCreator
implements KeyCreator {
    private final StringLogger logger;

    public IsolatedTransactionKeyCreator(Logging logging) {
        this.logger = logging.getLogger(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int getOrCreate(AbstractTransactionManager txManager, EntityIdGenerator idGenerator, PersistenceManager persistence, String name) {
        try {
            Transaction runningTransaction = txManager.suspend();
            try {
                txManager.begin(ForceMode.unforced);
                int id = this.createKey(idGenerator, persistence, name);
                txManager.commit();
                int n = id;
                return n;
            }
            catch (Throwable t) {
                this.logger.error("Unable to create key '" + name + "'", t);
                try {
                    txManager.rollback();
                    throw new TransactionFailureException("Unable to create key '" + name + "'", t);
                }
                catch (Throwable tt) {
                    this.logger.error("Unable to rollback after failure to create key '" + name + "'", t);
                }
                throw new TransactionFailureException("Unable to create key '" + name + "'", t);
            }
            finally {
                if (runningTransaction != null) {
                    txManager.resume(runningTransaction);
                }
            }
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Unable to resume or suspend running transaction", e);
        }
        catch (InvalidTransactionException e) {
            throw new TransactionFailureException("Unable to resume or suspend running transaction", e);
        }
    }

    protected abstract int createKey(EntityIdGenerator var1, PersistenceManager var2, String var3);
}

