/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

public class NeoStoreIndexStoreView
implements IndexingService.IndexStoreView {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    public NeoStoreIndexStoreView(NeoStore neoStore) {
        this.propertyStore = neoStore.getPropertyStore();
        this.nodeStore = neoStore.getNodeStore();
    }

    @Override
    public Iterator<Pair<Integer, Object>> getNodeProperties(long nodeId, Iterator<Long> propertyKeysIterator) {
        long firstPropertyId = this.nodeStore.forceGetRecord(nodeId).getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return IteratorUtil.emptyIterator();
        }
        final Set<Long> propertyKeys = IteratorUtil.asSet(IteratorUtil.asIterable(propertyKeysIterator));
        return Iterables.flatMap(new Function<PropertyRecord, Iterator<Pair<Integer, Object>>>(){

            @Override
            public Iterator<Pair<Integer, Object>> apply(PropertyRecord propertyRecord) {
                return Iterables.filter(NeoStoreIndexStoreView.this.notNull(), Iterables.map(NeoStoreIndexStoreView.this.propertiesThatAreIn(propertyKeys), propertyRecord.getPropertyBlocks().iterator()));
            }
        }, this.propertyStore.getPropertyRecordChain(firstPropertyId).iterator());
    }

    @Override
    public IndexingService.StoreScan visitNodesWithPropertyAndLabel(IndexDescriptor descriptor, Visitor<Pair<Long, Object>> visitor) {
        long propertyKeyId = descriptor.getPropertyKeyId();
        final NodeIndexingProcessor processor = new NodeIndexingProcessor(this.propertyStore, propertyKeyId, visitor);
        long labelId = descriptor.getLabelId();
        final NodeLabelFilterPredicate predicate = new NodeLabelFilterPredicate(this.nodeStore, labelId);
        return new IndexingService.StoreScan(){

            @Override
            public void run() {
                processor.applyFiltered(NeoStoreIndexStoreView.this.nodeStore, predicate);
            }

            @Override
            public void stop() {
                processor.stopScanning();
            }
        };
    }

    private Predicate<Pair<Integer, Object>> notNull() {
        return new Predicate<Pair<Integer, Object>>(){

            @Override
            public boolean accept(Pair<Integer, Object> item) {
                return item != null;
            }
        };
    }

    private Function<PropertyBlock, Pair<Integer, Object>> propertiesThatAreIn(final Set<Long> propertyKeys) {
        return new Function<PropertyBlock, Pair<Integer, Object>>(){

            @Override
            public Pair<Integer, Object> apply(PropertyBlock property) {
                int keyId = property.getKeyIndexId();
                if (propertyKeys.contains(keyId)) {
                    NeoStoreIndexStoreView.this.propertyStore.ensureHeavy(property);
                    Object propertyValue = property.getType().getValue(property, NeoStoreIndexStoreView.this.propertyStore);
                    return Pair.of(property.getKeyIndexId(), propertyValue);
                }
                return null;
            }
        };
    }

    private class NodeLabelFilterPredicate
    implements Predicate<NodeRecord> {
        private final NodeStore nodeStore;
        private final long labelId;

        public NodeLabelFilterPredicate(NodeStore nodeStore, long labelId) {
            this.nodeStore = nodeStore;
            this.labelId = labelId;
        }

        @Override
        public boolean accept(NodeRecord node) {
            for (long nodeLabelId : this.nodeStore.getLabelsForNode(node)) {
                if (nodeLabelId != this.labelId) continue;
                return true;
            }
            return false;
        }
    }

    private class NodeIndexingProcessor
    extends RecordStore.Processor {
        private final PropertyStore propertyStore;
        private final long propertyKeyId;
        private final Visitor<Pair<Long, Object>> visitor;

        public NodeIndexingProcessor(PropertyStore propertyStore, long propertyKeyId, Visitor<Pair<Long, Object>> visitor) {
            this.propertyStore = propertyStore;
            this.propertyKeyId = propertyKeyId;
            this.visitor = visitor;
        }

        @Override
        public void processNode(RecordStore<NodeRecord> nodeStore, NodeRecord node) {
            long firstPropertyId = node.getCommittedNextProp();
            if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
                return;
            }
            for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
                for (PropertyBlock property : propertyRecord.getPropertyBlocks()) {
                    if ((long)property.getKeyIndexId() != this.propertyKeyId) continue;
                    this.propertyStore.ensureHeavy(property);
                    Object propertyValue = property.getType().getValue(property, this.propertyStore);
                    this.visitor.visit(Pair.of(node.getId(), propertyValue));
                }
            }
        }
    }
}

