/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.InterceptingWriteTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.persistence.IdGenerationFailedException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;

public class NeoStoreXaDataSource
extends LogBackedXaDataSource {
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    public static final byte[] BRANCH_ID = UTF8.encode("414141");
    public static final String LOGICAL_LOG_DEFAULT_NAME = "nioneo_logical.log";
    private final StoreFactory storeFactory;
    private final XaFactory xaFactory;
    private final JobScheduler scheduler;
    private final UpdateableSchemaState updateableSchemaState;
    private final Config config;
    private final LifeSupport life = new LifeSupport();
    private NeoStore neoStore;
    private IndexingService indexingService;
    private XaContainer xaContainer;
    private ArrayMap<Class<?>, Store> idGenerators;
    private final LockManager lockManager;
    private File storeDir;
    private boolean readOnly;
    private final TransactionInterceptorProviders providers;
    private boolean logApplied = false;
    private final StringLogger msgLog;
    private final TransactionStateFactory stateFactory;
    private final CacheAccessBackDoor cacheAccess;
    private final Logging logging;
    private final DependencyResolver dependencyResolver;

    public NeoStoreXaDataSource(Config config, StoreFactory sf, LockManager lockManager, StringLogger stringLogger, XaFactory xaFactory, TransactionStateFactory stateFactory, CacheAccessBackDoor cacheAccess, TransactionInterceptorProviders providers, JobScheduler scheduler, Logging logging, UpdateableSchemaState updateableSchemaState, DependencyResolver dependencyResolver) throws IOException {
        super(BRANCH_ID, DEFAULT_DATA_SOURCE_NAME);
        this.config = config;
        this.stateFactory = stateFactory;
        this.cacheAccess = cacheAccess;
        this.dependencyResolver = dependencyResolver;
        this.providers = providers;
        this.scheduler = scheduler;
        this.logging = logging;
        this.readOnly = config.get(Configuration.read_only);
        this.lockManager = lockManager;
        this.msgLog = stringLogger;
        this.storeFactory = sf;
        this.xaFactory = xaFactory;
        this.updateableSchemaState = updateableSchemaState;
    }

    @Override
    public void init() {
        this.life.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.readOnly = this.config.get(Configuration.read_only);
        this.storeDir = this.config.get(Configuration.store_dir);
        File store = this.config.get(Configuration.neo_store);
        this.storeFactory.ensureStoreExists();
        TransactionFactory tf = this.providers.shouldInterceptCommitting() ? new InterceptingTransactionFactory() : new TransactionFactory();
        this.neoStore = this.storeFactory.newNeoStore(store);
        SchemaIndexProvider indexProvider = this.dependencyResolver.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        this.indexingService = this.life.add(new IndexingService(this.scheduler, indexProvider, new NeoStoreIndexStoreView(this.neoStore), this.updateableSchemaState, this.logging));
        this.xaContainer = this.xaFactory.newXaContainer(this, this.config.get(Configuration.logical_log), new CommandFactory(this.neoStore, this.indexingService), tf, this.stateFactory, this.providers);
        try {
            if (!this.readOnly) {
                this.neoStore.setRecoveredStatus(true);
                try {
                    this.indexingService.initIndexes(this.loadIndexRules());
                    this.xaContainer.openLogicalLog();
                }
                finally {
                    this.neoStore.setRecoveredStatus(false);
                }
            }
            if (!this.xaContainer.getResourceManager().hasRecoveredTransactions()) {
                this.neoStore.makeStoreOk();
            } else {
                this.msgLog.debug("Waiting for TM to take care of recovered transactions.");
            }
            this.idGenerators = new ArrayMap(5, false, false);
            this.idGenerators.put(Node.class, this.neoStore.getNodeStore());
            this.idGenerators.put(Relationship.class, this.neoStore.getRelationshipStore());
            this.idGenerators.put(RelationshipType.class, this.neoStore.getRelationshipTypeStore());
            this.idGenerators.put(PropertyStore.class, this.neoStore.getPropertyStore());
            this.idGenerators.put(PropertyIndex.class, this.neoStore.getPropertyStore().getIndexStore());
            this.setLogicalLogAtCreationTime(this.xaContainer.getLogicalLog());
            this.life.start();
        }
        catch (Throwable e) {
            try {
                this.neoStore.close();
            }
            catch (Exception closeException) {
                this.msgLog.logMessage("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
    }

    public NeoStore getNeoStore() {
        return this.neoStore;
    }

    public IndexingService getIndexService() {
        return this.indexingService;
    }

    @Override
    public void stop() {
        super.stop();
        this.life.stop();
        if (!this.readOnly) {
            this.indexingService.flushAll();
            this.neoStore.flushAll();
        }
        this.xaContainer.close();
        if (this.logApplied) {
            this.neoStore.rebuildIdGenerators();
            this.logApplied = false;
        }
        this.neoStore.close();
        this.msgLog.info("NeoStore closed");
    }

    @Override
    public void shutdown() {
        this.life.shutdown();
    }

    public StoreId getStoreId() {
        return this.neoStore.getStoreId();
    }

    @Override
    public NeoStoreXaConnection getXaConnection() {
        return new NeoStoreXaConnection(this.neoStore, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    public long nextId(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.nextId();
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getHighestPossibleIdInUse();
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getNumberOfIdsInUse();
    }

    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    @Override
    public long getCreationTime() {
        return this.neoStore.getCreationTime();
    }

    @Override
    public long getRandomIdentifier() {
        return this.neoStore.getRandomNumber();
    }

    @Override
    public long getCurrentLogVersion() {
        return this.neoStore.getVersion();
    }

    public long incrementAndGetLogVersion() {
        return this.neoStore.incrementVersion();
    }

    public void setCurrentLogVersion(long version) {
        this.neoStore.setVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastCommittedTxId(long txId) {
        this.neoStore.setRecoveredStatus(true);
        try {
            this.neoStore.setLastCommittedTx(txId);
        }
        finally {
            this.neoStore.setRecoveredStatus(false);
        }
    }

    ReadTransaction getReadOnlyTransaction() {
        return new ReadTransaction(this.neoStore);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<WindowPoolStats> getWindowPoolStats() {
        return this.neoStore.getAllWindowPoolStats();
    }

    @Override
    public long getLastCommittedTxId() {
        return this.neoStore.getLastCommittedTx();
    }

    @Override
    public XaContainer getXaContainer() {
        return this.xaContainer;
    }

    @Override
    public boolean setRecovered(boolean recovered) {
        boolean currentValue = this.neoStore.isInRecoveryMode();
        this.neoStore.setRecoveredStatus(true);
        return currentValue;
    }

    @Override
    public ClosableIterable<File> listStoreFiles(boolean includeLogicalLogs) {
        final ArrayList<File> files = new ArrayList<File>();
        File neostoreFile = null;
        Pattern logFilePattern = this.getXaContainer().getLogicalLog().getHistoryFileNamePattern();
        for (File dbFile : this.storeDir.listFiles()) {
            String name = dbFile.getName();
            if (!dbFile.isFile()) continue;
            if (name.equals("neostore")) {
                neostoreFile = dbFile;
                continue;
            }
            if ((name.startsWith("neostore") || name.equals("index.db")) && !name.endsWith(".id")) {
                files.add(dbFile);
                continue;
            }
            if (!includeLogicalLogs || !logFilePattern.matcher(dbFile.getName()).matches()) continue;
            files.add(dbFile);
        }
        files.add(neostoreFile);
        return new ClosableIterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return files.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    public void logStoreVersions() {
    }

    public void logIdUsage() {
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        manager.registerAll(Diagnostics.class, this);
    }

    private Iterator<IndexRule> loadIndexRules() {
        return Iterables.map(new Function<SchemaRule, IndexRule>(){

            @Override
            public IndexRule apply(SchemaRule schemaRule) {
                return (IndexRule)schemaRule;
            }
        }, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        }, this.neoStore.getSchemaStore().loadAll()));
    }

    private class TransactionFactory
    extends XaTransactionFactory {
        private TransactionFactory() {
        }

        @Override
        public XaTransaction create(int identifier, TransactionState state) {
            return new WriteTransaction(identifier, this.getLogicalLog(), state, NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.cacheAccess, NeoStoreXaDataSource.this.indexingService);
        }

        @Override
        public void recoveryComplete() {
            NeoStoreXaDataSource.this.msgLog.debug("Recovery complete, all transactions have been resolved");
            NeoStoreXaDataSource.this.msgLog.debug("Rebuilding id generators as needed. This can take a while for large stores...");
            NeoStoreXaDataSource.this.neoStore.flushAll();
            NeoStoreXaDataSource.this.neoStore.makeStoreOk();
            NeoStoreXaDataSource.this.neoStore.setVersion(NeoStoreXaDataSource.this.xaContainer.getLogicalLog().getHighestLogVersion());
            NeoStoreXaDataSource.this.msgLog.debug("Rebuild of id generators complete.");
        }

        @Override
        public long getCurrentVersion() {
            return NeoStoreXaDataSource.this.neoStore.getVersion();
        }

        @Override
        public long getAndSetNewVersion() {
            return NeoStoreXaDataSource.this.neoStore.incrementVersion();
        }

        @Override
        public void setVersion(long version) {
            NeoStoreXaDataSource.this.neoStore.setVersion(version);
        }

        @Override
        public void flushAll() {
            NeoStoreXaDataSource.this.neoStore.flushAll();
            NeoStoreXaDataSource.this.indexingService.flushAll();
        }

        @Override
        public long getLastCommittedTx() {
            return NeoStoreXaDataSource.this.neoStore.getLastCommittedTx();
        }
    }

    private class InterceptingTransactionFactory
    extends TransactionFactory {
        private InterceptingTransactionFactory() {
        }

        @Override
        public XaTransaction create(int identifier, TransactionState state) {
            TransactionInterceptor first = NeoStoreXaDataSource.this.providers.resolveChain(NeoStoreXaDataSource.this);
            return new InterceptingWriteTransaction(identifier, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, state, NeoStoreXaDataSource.this.cacheAccess, NeoStoreXaDataSource.this.indexingService, NeoStoreXaDataSource.this.lockManager, first);
        }
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private final NeoStore neoStore;
        private final IndexingService indexingService;

        CommandFactory(NeoStore neoStore, IndexingService indexingService) {
            this.neoStore = neoStore;
            this.indexingService = indexingService;
        }

        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(this.neoStore, this.indexingService, byteChannel, buffer);
        }
    }

    private static enum Diagnostics implements DiagnosticsExtractor<NeoStoreXaDataSource>
    {
        NEO_STORE_VERSIONS("Store versions:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logVersions(log);
            }
        }
        ,
        NEO_STORE_ID_USAGE("Id usage:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logIdUsage(log);
            }
        }
        ,
        PERSISTENCE_WINDOW_POOL_STATS("Persistence Window Pool stats:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logAllWindowPoolStats(log);
            }

            @Override
            boolean applicable(DiagnosticsPhase phase) {
                return phase.isExplicitlyRequested();
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(final NeoStoreXaDataSource source, DiagnosticsPhase phase, StringLogger log) {
            if (this.applicable(phase)) {
                log.logLongMessage(this.message, new Visitor<StringLogger.LineLogger>(){

                    @Override
                    public boolean visit(StringLogger.LineLogger logger) {
                        Diagnostics.this.dump(source, logger);
                        return false;
                    }
                }, true);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreXaDataSource var1, StringLogger.LineLogger var2);
    }

    public static abstract class Configuration
    extends LogBackedXaDataSource.Configuration {
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
        public static final Setting<File> logical_log = InternalAbstractGraphDatabase.Configuration.logical_log;
    }
}

