/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;

public class StoreMigrator {
    private final MigrationProgressMonitor progressMonitor;

    public StoreMigrator(MigrationProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void migrate(LegacyStore legacyStore, NeoStore neoStore) throws IOException {
        this.progressMonitor.started();
        new Migration(legacyStore, neoStore).migrate();
        this.progressMonitor.finished();
    }

    protected class Migration {
        private final LegacyStore legacyStore;
        private final NeoStore neoStore;
        private final long totalEntities;
        private int percentComplete;

        public Migration(LegacyStore legacyStore, NeoStore neoStore) {
            this.legacyStore = legacyStore;
            this.neoStore = neoStore;
            this.totalEntities = legacyStore.getNodeStoreReader().getMaxId();
        }

        private void migrate() throws IOException {
            this.migrateNeoStore(this.neoStore);
            this.migrateNodes(this.neoStore.getNodeStore());
            this.neoStore.close();
            this.legacyStore.close();
            this.legacyStore.copyRelationshipStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeNameStore(this.neoStore);
            this.legacyStore.copyPropertyStore(this.neoStore);
            this.legacyStore.copyPropertyIndexStore(this.neoStore);
            this.legacyStore.copyPropertyIndexNameStore(this.neoStore);
            this.legacyStore.copyDynamicStringPropertyStore(this.neoStore);
            this.legacyStore.copyDynamicArrayPropertyStore(this.neoStore);
        }

        private void migrateNeoStore(NeoStore neoStore) throws IOException {
            this.legacyStore.copyNeoStore(neoStore);
            neoStore.setStoreVersion(NeoStore.versionStringToLong("v0.A.1"));
        }

        private void migrateNodes(NodeStore nodeStore) throws IOException {
            Iterable<NodeRecord> records = this.legacyStore.getNodeStoreReader().readNodeStore();
            for (NodeRecord nodeRecord : records) {
                this.reportProgress(nodeRecord.getId());
                nodeStore.setHighId(nodeRecord.getId() + 1L);
                if (nodeRecord.inUse()) {
                    nodeStore.updateRecord(nodeRecord);
                    continue;
                }
                nodeStore.freeId(nodeRecord.getId());
            }
            this.legacyStore.getNodeStoreReader().close();
        }

        private void reportProgress(long id) {
            int newPercent = (int)(id * 100L / this.totalEntities);
            if (newPercent > this.percentComplete) {
                this.percentComplete = newPercent;
                StoreMigrator.this.progressMonitor.percentComplete(this.percentComplete);
            }
        }
    }
}

