/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;

public abstract class ResourceClosingIterator<T, V>
implements ResourceIterator<V> {
    private AutoCloseable closeable;
    private final Iterator<T> iterator;

    public static <T> ResourceIterator<T> newResourceIterator(AutoCloseable closeable, Iterator<T> iterator) {
        return new ResourceClosingIterator<T, T>(closeable, (Iterator)iterator){

            @Override
            public T map(T elem) {
                return elem;
            }
        };
    }

    ResourceClosingIterator(AutoCloseable closeable, Iterator<T> iterator) {
        this.closeable = closeable;
        this.iterator = iterator;
    }

    @Override
    public void close() {
        try {
            this.closeable.close();
            this.closeable = IteratorUtil.EMPTY_CLOSEABLE;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public abstract V map(T var1);

    @Override
    public V next() {
        try {
            return this.map(this.iterator.next());
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

