/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.InternalSchemaActions;
import org.neo4j.kernel.PropertyConstraintCreator;
import org.neo4j.kernel.PropertyUniqueConstraintCreator;

public class BaseConstraintCreator
implements ConstraintCreator {
    protected final InternalSchemaActions actions;
    protected final Label label;

    public BaseConstraintCreator(InternalSchemaActions actions, Label label) {
        this.actions = actions;
        this.label = label;
        this.assertInTransaction();
    }

    @Override
    public ConstraintCreator on(String propertyKey) {
        return new PropertyConstraintCreator(this.actions, this.label, propertyKey);
    }

    @Override
    public ConstraintCreator unique() {
        return new PropertyUniqueConstraintCreator(this.actions, this.label, null);
    }

    @Override
    public ConstraintDefinition create() {
        this.assertInTransaction();
        throw new IllegalStateException("Not constraint assertions specified");
    }

    protected final void assertInTransaction() {
        this.actions.assertInTransaction();
    }
}

