/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.BaseConstraintCreator;
import org.neo4j.kernel.IndexCreatorImpl;
import org.neo4j.kernel.IndexDefinitionImpl;
import org.neo4j.kernel.InternalSchemaActions;
import org.neo4j.kernel.PropertyUniqueConstraintDefinition;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.SchemaStatement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.StatementTokenNameLookup;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class SchemaImpl
implements Schema {
    private final ThreadToStatementContextBridge ctxProvider;
    private final InternalSchemaActions actions;

    public SchemaImpl(ThreadToStatementContextBridge ctxProvider) {
        this.ctxProvider = ctxProvider;
        this.actions = new GDBSchemaActions(ctxProvider);
    }

    @Override
    public IndexCreator indexFor(Label label) {
        this.assertInTransaction();
        return new IndexCreatorImpl(this.actions, label);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        this.assertInTransaction();
        try (ReadStatement statement = this.ctxProvider.readStatement();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            long labelId = statement.labelGetForName(label.name());
            if (labelId == -1L) {
                List<IndexDefinition> list = Collections.emptyList();
                return list;
            }
            this.addDefinitions(definitions, statement, statement.indexesGetForLabel(labelId), false);
            this.addDefinitions(definitions, statement, statement.uniqueIndexesGetForLabel(labelId), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        this.assertInTransaction();
        try (ReadStatement statement = this.ctxProvider.readStatement();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            this.addDefinitions(definitions, statement, statement.indexesGetAll(), false);
            this.addDefinitions(definitions, statement, statement.uniqueIndexesGetAll(), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, final ReadStatement statement, Iterator<IndexDescriptor> indexes, final boolean constraintIndex) {
        IteratorUtil.addToCollection(Iterables.map(new Function<IndexDescriptor, IndexDefinition>(){

            @Override
            public IndexDefinition apply(IndexDescriptor rule) {
                try {
                    Label label = DynamicLabel.label(statement.labelGetName(rule.getLabelId()));
                    String propertyKey = statement.propertyKeyGetName(rule.getPropertyKeyId());
                    return new IndexDefinitionImpl(SchemaImpl.this.actions, label, propertyKey, constraintIndex);
                }
                catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
                    throw new RuntimeException(e);
                }
            }
        }, indexes), definitions);
    }

    @Override
    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.assertInTransaction();
        long timeout = System.currentTimeMillis() + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    @Override
    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.assertInTransaction();
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + IteratorUtil.asCollection(iter));
            }
            IndexDefinition index = iter.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Schema.IndexState getIndexState(IndexDefinition index) {
        this.assertInTransaction();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try (ReadStatement statement = this.ctxProvider.readStatement();){
            long labelId = statement.labelGetForName(index.getLabel().name());
            long propertyKeyId = statement.propertyKeyGetForName(propertyKey);
            if (labelId == -1L) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            if (propertyKeyId == -1L) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            IndexDescriptor descriptor = statement.indexesGetForLabelAndPropertyKey(labelId, propertyKeyId);
            InternalIndexState indexState = statement.indexGetState(descriptor);
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getIndexFailure(IndexDefinition index) {
        this.assertInTransaction();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try (ReadStatement statement = this.ctxProvider.readStatement();){
            long labelId = statement.labelGetForName(index.getLabel().name());
            long propertyKeyId = statement.propertyKeyGetForName(propertyKey);
            if (labelId == -1L) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            if (propertyKeyId == -1L) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            IndexDescriptor indexId = statement.indexesGetForLabelAndPropertyKey(labelId, propertyKeyId);
            String string = statement.indexGetFailure(indexId);
            return string;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
        }
    }

    @Override
    public ConstraintCreator constraintFor(Label label) {
        this.assertInTransaction();
        return new BaseConstraintCreator(this.actions, label);
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        this.assertInTransaction();
        try (ReadStatement statement = this.ctxProvider.readStatement();){
            Iterator<UniquenessConstraint> constraints = statement.constraintsGetAll();
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(statement, constraints);
            return iterable;
        }
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        this.assertInTransaction();
        try (ReadStatement statement = this.ctxProvider.readStatement();){
            long labelId = statement.labelGetForName(label.name());
            if (labelId == -1L) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator<UniquenessConstraint> constraints = statement.constraintsGetForLabel(labelId);
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(statement, constraints);
            return iterable;
        }
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(final ReadStatement statement, Iterator<UniquenessConstraint> constraints) {
        Iterator<ConstraintDefinition> definitions = Iterables.map(new Function<UniquenessConstraint, ConstraintDefinition>(){

            @Override
            public ConstraintDefinition apply(UniquenessConstraint constraint) {
                long labelId = constraint.label();
                try {
                    Label label = DynamicLabel.label(statement.labelGetName(labelId));
                    return new PropertyUniqueConstraintDefinition(SchemaImpl.this.actions, label, statement.propertyKeyGetName(constraint.propertyKeyId()));
                }
                catch (PropertyKeyIdNotFoundKernelException e) {
                    throw new ThisShouldNotHappenError("Mattias", "Couldn't find property name for " + constraint.propertyKeyId(), e);
                }
                catch (LabelNotFoundKernelException e) {
                    throw new ThisShouldNotHappenError("Stefan", "Couldn't find label name for label id " + labelId, e);
                }
            }
        }, constraints);
        return IteratorUtil.asCollection(definitions);
    }

    private void assertInTransaction() {
        this.ctxProvider.assertInTransaction();
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final ThreadToStatementContextBridge ctxProvider;

        public GDBSchemaActions(ThreadToStatementContextBridge ctxProvider) {
            this.ctxProvider = ctxProvider;
        }

        @Override
        public IndexDefinition createIndexDefinition(Label label, String propertyKey) {
            try (SchemaStatement statement = this.ctxProvider.schemaStatement();){
                long labelId = statement.labelGetOrCreateForName(label.name());
                long propertyKeyId = statement.propertyKeyGetOrCreateForName(propertyKey);
                statement.indexCreate(labelId, propertyKeyId);
                IndexDefinitionImpl indexDefinitionImpl = new IndexDefinitionImpl(this, label, propertyKey, false);
                return indexDefinitionImpl;
            }
        }

        @Override
        public void dropIndexDefinitions(Label label, String propertyKey) {
            try (SchemaStatement statement = this.ctxProvider.schemaStatement();){
                long labelId = statement.labelGetForName(label.name());
                long propertyKeyId = statement.propertyKeyGetForName(propertyKey);
                if (labelId != -1L && propertyKeyId != -1L) {
                    statement.indexDrop(statement.indexesGetForLabelAndPropertyKey(labelId, propertyKeyId));
                }
            }
            catch (DropIndexFailureException | SchemaRuleNotFoundException e) {
                throw new ConstraintViolationException(String.format("Unable to drop index on label `%s` for property %s.", label.name(), propertyKey), e);
            }
        }

        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(Label label, String propertyKey) {
            try (SchemaStatement statement = this.ctxProvider.schemaStatement();){
                long labelId = statement.labelGetOrCreateForName(label.name());
                long propertyKeyId = statement.propertyKeyGetOrCreateForName(propertyKey);
                statement.uniquenessConstraintCreate(labelId, propertyKeyId);
                PropertyUniqueConstraintDefinition propertyUniqueConstraintDefinition = new PropertyUniqueConstraintDefinition(this, label, propertyKey);
                return propertyUniqueConstraintDefinition;
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String propertyKey) {
            try (SchemaStatement statement = this.ctxProvider.schemaStatement();){
                long labelId = statement.labelGetOrCreateForName(label.name());
                long propertyKeyId = statement.propertyKeyGetOrCreateForName(propertyKey);
                UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
                statement.constraintDrop(constraint);
            }
            catch (DropConstraintFailureException | IllegalTokenNameException | TooManyLabelsException e) {
                throw new ThisShouldNotHappenError("Mattias", "Unable to drop property unique constraint");
            }
        }

        @Override
        public String getUserMessage(KernelException e) {
            try (ReadStatement statement = this.ctxProvider.readStatement();){
                String string = e.getUserMessage(new StatementTokenNameLookup(statement));
                return string;
            }
        }

        @Override
        public void assertInTransaction() {
            this.ctxProvider.assertInTransaction();
        }
    }
}

