/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.kernel.api.DataStatement;
import org.neo4j.kernel.api.InvalidTransactionTypeException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.MicroTransaction;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.SchemaStatement;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.operations.LegacyKernelOperations;

public abstract class KernelTransactionImplementation
implements KernelTransaction {
    private TransactionType transactionType = TransactionType.ANY;
    final StatementOperationParts operations;
    private boolean closing;
    private boolean closed;
    final LegacyKernelOperations legacyKernelOperations;
    private Statement currentStatement;

    protected KernelTransactionImplementation(StatementOperationParts operations, LegacyKernelOperations legacyKernelOperations) {
        this.operations = operations;
        this.legacyKernelOperations = legacyKernelOperations;
    }

    @Override
    public ReadStatement acquireReadStatement() {
        this.assertOpen();
        return new ReadStatement(this, this.acquireStatement());
    }

    @Override
    public DataStatement acquireDataStatement() throws InvalidTransactionTypeException {
        this.assertOpen();
        this.transactionType = this.transactionType.upgradeToDataTransaction();
        return new DataStatement(this, this.acquireStatement());
    }

    @Override
    public SchemaStatement acquireSchemaStatement() throws InvalidTransactionTypeException {
        this.assertOpen();
        this.transactionType = this.transactionType.upgradeToSchemaTransaction();
        return new SchemaStatement(this, this.acquireStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws TransactionFailureException {
        this.beginClose();
        try {
            this.doCommit();
            this.close();
        }
        finally {
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws TransactionFailureException {
        this.beginClose();
        try {
            this.doRollback();
            this.close();
        }
        finally {
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RESULT, FAILURE extends KernelException> RESULT execute(MicroTransaction<RESULT, FAILURE> transaction) throws FAILURE {
        Statement statement = this.acquireStatement();
        try {
            Object RESULT = transaction.work.perform(this.operations, statement);
            return RESULT;
        }
        finally {
            this.releaseStatement(statement);
        }
    }

    protected abstract void doCommit() throws TransactionFailureException;

    protected abstract void doRollback() throws TransactionFailureException;

    protected abstract Statement newStatement();

    private Statement acquireStatement() {
        if (this.currentStatement == null) {
            this.currentStatement = this.newStatement();
        }
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    void releaseStatement(Statement statement) {
        assert (this.currentStatement == statement);
        if (statement.release()) {
            this.currentStatement = null;
            statement.close();
        }
    }

    private void close() {
        this.assertOpen();
        this.closed = true;
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("This transaction has already been completed.");
        }
    }

    private void beginClose() {
        this.assertOpen();
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
        this.closing = true;
    }

    private static enum TransactionType {
        ANY,
        DATA{

            @Override
            TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeException {
                throw new InvalidTransactionTypeException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeException {
                throw new InvalidTransactionTypeException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeException {
            return DATA;
        }

        TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeException {
            return SCHEMA;
        }
    }
}

