/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.Closeable;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.scan.LabelScanReader;
import org.neo4j.kernel.api.scan.LabelScanStore;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.state.TxState;

public class Statement
implements TxState.Holder,
Closeable {
    protected final LockHolder lockHolder;
    protected final TxState.Holder txStateHolder;
    protected final IndexReaderFactory indexReaderFactory;
    protected final LabelScanStore labelScanStore;
    private LabelScanReader labelScanReader;
    private int referenceCount;

    public Statement(IndexReaderFactory indexReaderFactory, LabelScanStore labelScanStore, TxState.Holder txStateHolder, LockHolder lockHolder) {
        this.lockHolder = lockHolder;
        this.indexReaderFactory = indexReaderFactory;
        this.txStateHolder = txStateHolder;
        this.labelScanStore = labelScanStore;
    }

    @Override
    public TxState txState() {
        return this.txStateHolder.txState();
    }

    @Override
    public boolean hasTxState() {
        return this.txStateHolder.hasTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }

    @Override
    public void close() {
        this.indexReaderFactory.close();
    }

    public LockHolder locks() {
        return this.lockHolder;
    }

    public IndexReader getIndexReader(long indexId) throws IndexNotFoundKernelException {
        return this.indexReaderFactory.newReader(indexId);
    }

    public LabelScanReader getLabelScanReader() {
        if (this.labelScanReader == null) {
            this.labelScanReader = this.labelScanStore.newReader();
        }
        return this.labelScanReader;
    }

    final void acquire() {
        ++this.referenceCount;
    }

    final boolean release() {
        return --this.referenceCount == 0;
    }

    final void forceClose() {
        this.referenceCount = 0;
        this.close();
    }
}

