/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.MicroTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementOperationParts;
import org.neo4j.kernel.api.exceptions.BeginTransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class Transactor {
    private final AbstractTransactionManager txManager;

    public Transactor(AbstractTransactionManager txManager) {
        this.txManager = txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT, FAILURE extends KernelException> RESULT execute(Work<RESULT, FAILURE> work) throws FAILURE, TransactionalException {
        Transaction previousTransaction = this.suspendTransaction();
        try {
            RESULT RESULT;
            block12: {
                KernelTransaction tx;
                block11: {
                    this.beginTransaction();
                    tx = this.txManager.getKernelTransaction();
                    boolean success = false;
                    try {
                        RESULT result = tx.execute(new MicroTransaction<RESULT, FAILURE>(work));
                        success = true;
                        RESULT = result;
                        if (!success) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (success) {
                                tx.commit();
                            } else {
                                tx.rollback();
                            }
                            throw throwable;
                        }
                        catch (TransactionalException failure) {
                            previousTransaction = null;
                            throw failure;
                        }
                    }
                    tx.commit();
                    break block12;
                }
                tx.rollback();
            }
            return RESULT;
        }
        finally {
            if (previousTransaction != null) {
                this.resumeTransaction(previousTransaction);
            }
        }
    }

    private void beginTransaction() throws BeginTransactionFailureException {
        try {
            this.txManager.begin();
        }
        catch (NotSupportedException | SystemException e) {
            throw new BeginTransactionFailureException((Exception)e);
        }
    }

    private Transaction suspendTransaction() throws TransactionFailureException {
        Transaction existingTransaction;
        try {
            existingTransaction = this.txManager.suspend();
        }
        catch (SystemException failure) {
            throw new TransactionFailureException(failure);
        }
        return existingTransaction;
    }

    private void resumeTransaction(Transaction existingTransaction) throws TransactionFailureException {
        try {
            this.txManager.resume(existingTransaction);
        }
        catch (InvalidTransactionException failure) {
            throw new ThisShouldNotHappenError("Tobias Lindaaker", "Transaction resumed in the same transaction manager as it was suspended from should not be invalid. The Neo4j code base does not throw InvalidTransactionException", failure);
        }
        catch (SystemException failure) {
            throw new TransactionFailureException(failure);
        }
    }

    public static interface Work<RESULT, FAILURE extends KernelException> {
        public RESULT perform(StatementOperationParts var1, Statement var2) throws FAILURE;
    }
}

