/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.operations;

import java.util.Iterator;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaAndDataModificationInSameTransactionException;
import org.neo4j.kernel.api.operations.EntityReadOperations;
import org.neo4j.kernel.api.operations.EntityWriteOperations;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.constraints.ConstraintValidationKernelException;
import org.neo4j.kernel.impl.api.constraints.UnableToValidateConstraintKernelException;
import org.neo4j.kernel.impl.api.constraints.UniqueConstraintViolationKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class ConstraintEnforcingEntityWriteOperations
implements EntityWriteOperations {
    private final EntityWriteOperations entityWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final SchemaReadOperations schemaReadOperations;

    public ConstraintEnforcingEntityWriteOperations(EntityWriteOperations entityWriteOperations, EntityReadOperations entityReadOperations, SchemaReadOperations schemaReadOperations) {
        this.entityWriteOperations = entityWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.schemaReadOperations = schemaReadOperations;
    }

    @Override
    public boolean nodeAddLabel(Statement state, long nodeId, long labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        Iterator<UniquenessConstraint> constraints = this.schemaReadOperations.constraintsGetForLabel(state, labelId);
        while (constraints.hasNext()) {
            UniquenessConstraint constraint = constraints.next();
            long propertyKeyId = constraint.propertyKeyId();
            Property property = this.entityReadOperations.nodeGetProperty(state, nodeId, propertyKeyId);
            if (!property.isDefined()) continue;
            this.validateNoExistingNodeWithLabelAndProperty(state, labelId, (SafeProperty)property);
        }
        return this.entityWriteOperations.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(Statement state, long nodeId, SafeProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        PrimitiveLongIterator labelIds = this.entityReadOperations.nodeGetLabels(state, nodeId);
        while (labelIds.hasNext()) {
            long propertyKeyId;
            long labelId = labelIds.next();
            Iterator<UniquenessConstraint> constraintIterator = this.schemaReadOperations.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId = property.propertyKeyId());
            if (!constraintIterator.hasNext()) continue;
            this.validateNoExistingNodeWithLabelAndProperty(state, labelId, property);
        }
        return this.entityWriteOperations.nodeSetProperty(state, nodeId, property);
    }

    private void validateNoExistingNodeWithLabelAndProperty(Statement state, long labelId, SafeProperty property) throws ConstraintValidationKernelException {
        try {
            Object value = property.value();
            IndexDescriptor indexDescriptor = new IndexDescriptor(labelId, property.propertyKeyId());
            this.verifyIndexOnline(state, indexDescriptor);
            state.locks().acquireIndexEntryWriteLock(labelId, property.propertyKeyId(), property.valueAsString());
            PrimitiveLongIterator existingNodes = this.entityReadOperations.nodesGetFromIndexLookup(state, indexDescriptor, value);
            if (existingNodes.hasNext()) {
                throw new UniqueConstraintViolationKernelException(labelId, property.propertyKeyId(), value, existingNodes.next());
            }
        }
        catch (IndexNotFoundKernelException | IndexBrokenKernelException | SchemaAndDataModificationInSameTransactionException e) {
            throw new UnableToValidateConstraintKernelException(e);
        }
    }

    private void verifyIndexOnline(Statement state, IndexDescriptor indexDescriptor) throws IndexNotFoundKernelException, SchemaAndDataModificationInSameTransactionException, IndexBrokenKernelException {
        switch (this.schemaReadOperations.indexGetState(state, indexDescriptor)) {
            case ONLINE: {
                return;
            }
            case POPULATING: {
                throw new SchemaAndDataModificationInSameTransactionException();
            }
        }
        throw new IndexBrokenKernelException(this.schemaReadOperations.indexGetFailure(state, indexDescriptor));
    }

    @Override
    public void nodeDelete(Statement state, long nodeId) {
        this.entityWriteOperations.nodeDelete(state, nodeId);
    }

    @Override
    public void relationshipDelete(Statement state, long relationshipId) {
        this.entityWriteOperations.relationshipDelete(state, relationshipId);
    }

    @Override
    public boolean nodeRemoveLabel(Statement state, long nodeId, long labelId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public Property relationshipSetProperty(Statement state, long relationshipId, SafeProperty property) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(Statement state, SafeProperty property) {
        return this.entityWriteOperations.graphSetProperty(state, property);
    }

    @Override
    public Property nodeRemoveProperty(Statement state, long nodeId, long propertyKeyId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(Statement state, long relationshipId, long propertyKeyId) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(Statement state, long propertyKeyId) {
        return this.entityWriteOperations.graphRemoveProperty(state, propertyKeyId);
    }
}

