/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class BooleanProperty
extends SafeProperty {
    private final boolean value;
    private final long propertyKeyId;

    BooleanProperty(long propertyKeyId, boolean value) {
        this.propertyKeyId = propertyKeyId;
        this.value = value;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object other) {
        return other instanceof Boolean && Boolean.valueOf(this.value) == other;
    }

    @Override
    public Boolean value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BooleanProperty) {
            BooleanProperty that = (BooleanProperty)o;
            return this.propertyKeyId == that.propertyKeyId && this.value == that.value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = (int)(this.propertyKeyId ^ this.propertyKeyId >>> 32);
        return this.value ? result : -result;
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forBoolean((int)this.propertyKeyId, -1L, this.value);
    }
}

