/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.NumberPropertyWithin4Bytes;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class ByteProperty
extends NumberPropertyWithin4Bytes {
    private final byte value;
    private final long propertyKeyId;

    ByteProperty(long propertyKeyId, byte value) {
        this.value = value;
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Byte) {
            return (Byte)other == this.value;
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    boolean hasEqualValue(NumberPropertyWithin4Bytes that) {
        return this.value == ((ByteProperty)that).value;
    }

    @Override
    public Byte value() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forByte((int)this.propertyKeyId, -1L, this.value);
    }
}

