/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.NumberPropertyWithin4Bytes;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class FloatProperty
extends NumberPropertyWithin4Bytes {
    private final float value;
    private final long propertyKeyId;

    FloatProperty(long propertyKeyId, float value) {
        this.propertyKeyId = propertyKeyId;
        this.value = value;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Float) {
            boolean b = this.value == ((Float)other).floatValue();
            return b;
        }
        return this.valueCompare(Float.valueOf(this.value), other);
    }

    @Override
    boolean hasEqualValue(NumberPropertyWithin4Bytes that) {
        return this.value == ((FloatProperty)that).value;
    }

    @Override
    int valueBits() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public Number value() {
        return Float.valueOf(this.value);
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forFloat((int)this.propertyKeyId, -1L, this.value);
    }
}

