/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.concurrent.Callable;
import org.neo4j.kernel.api.properties.FullSizeProperty;

abstract class LazyProperty<T>
extends FullSizeProperty {
    private volatile Object value;

    LazyProperty(long propertyKeyId, Callable<? extends T> producer) {
        super(propertyKeyId);
        this.value = producer;
    }

    @Override
    final boolean hasEqualValue(FullSizeProperty that) {
        return this.valueEquals(((LazyProperty)that).value());
    }

    @Override
    public abstract boolean valueEquals(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T value() {
        Object value = this.value;
        if (value instanceof Callable) {
            LazyProperty lazyProperty = this;
            synchronized (lazyProperty) {
                value = this.value;
                if (value instanceof Callable) {
                    this.value = value = this.produceValue();
                }
            }
        }
        return this.castAndPrepareForReturn(value);
    }

    protected Object produceValue() {
        try {
            return ((Callable)this.value).call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected T castAndPrepareForReturn(Object value) {
        return (T)value;
    }
}

