/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.NumberPropertyWithin4Bytes;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;

final class ShortProperty
extends NumberPropertyWithin4Bytes {
    private final short value;
    private final long propertyKeyId;

    ShortProperty(long propertyKeyId, short value) {
        this.value = value;
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public long propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Short) {
            return this.value == (Short)other;
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    boolean hasEqualValue(NumberPropertyWithin4Bytes that) {
        return this.value == ((ShortProperty)that).value;
    }

    @Override
    public Short value() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    @Deprecated
    public PropertyData asPropertyDataJustForIntegration() {
        return PropertyDatas.forShort((int)this.propertyKeyId, -1L, this.value);
    }
}

