/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensionListener;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategy;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class KernelExtensions
extends DependencyResolver.Adapter
implements Lifecycle {
    private final List<KernelExtensionFactory<?>> kernelExtensionFactories;
    private final DependencyResolver dependencyResolver;
    private final LifeSupport life = new LifeSupport();
    private final Map<Iterable<String>, Lifecycle> extensions = new HashMap<Iterable<String>, Lifecycle>();
    private Iterable<KernelExtensionListener> listeners = Listeners.newListeners();
    private final UnsatisfiedDependencyStrategy unsatisfiedDepencyStrategy;

    public KernelExtensions(Iterable<KernelExtensionFactory<?>> kernelExtensionFactories, Config config, DependencyResolver dependencyResolver, UnsatisfiedDependencyStrategy unsatisfiedDepencyStrategy) {
        this.unsatisfiedDepencyStrategy = unsatisfiedDepencyStrategy;
        this.kernelExtensionFactories = Iterables.addAll(new ArrayList(), kernelExtensionFactories);
        this.dependencyResolver = dependencyResolver;
        this.life.addLifecycleListener(new LifecycleListener(){

            @Override
            public void notifyStatusChanged(final Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (to.equals((Object)LifecycleStatus.STARTED)) {
                    Listeners.notifyListeners(KernelExtensions.this.listeners, new Listeners.Notification<KernelExtensionListener>(){

                        @Override
                        public void notify(KernelExtensionListener listener) {
                            listener.startedKernelExtension(instance);
                        }
                    });
                } else if (to.equals((Object)LifecycleStatus.STOPPING)) {
                    Listeners.notifyListeners(KernelExtensions.this.listeners, new Listeners.Notification<KernelExtensionListener>(){

                        @Override
                        public void notify(KernelExtensionListener listener) {
                            listener.stoppingKernelExtension(instance);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void init() throws Throwable {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            Object configuration = this.getKernelExtensionDependencies(kernelExtensionFactory);
            try {
                this.extensions.put(kernelExtensionFactory.getKeys(), this.life.add(kernelExtensionFactory.newKernelExtension(configuration)));
            }
            catch (UnsatisfiedDepencyException e) {
                this.unsatisfiedDepencyStrategy.handle(kernelExtensionFactory, e);
            }
        }
        this.life.init();
    }

    @Override
    public void start() throws Throwable {
        this.life.start();
    }

    @Override
    public void stop() throws Throwable {
        this.life.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    public boolean isRegistered(Class<?> kernelExtensionFactoryClass) {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            if (!kernelExtensionFactoryClass.isInstance(kernelExtensionFactory)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addKernelExtension(KernelExtensionFactory kernelExtensionFactory) {
        if (this.kernelExtensionFactories.contains(kernelExtensionFactory)) {
            return;
        }
        Lifecycle extension = null;
        try {
            extension = kernelExtensionFactory.newKernelExtension(this.getKernelExtensionDependencies(kernelExtensionFactory));
            this.extensions.put(kernelExtensionFactory.getKeys(), extension);
            this.kernelExtensionFactories.add(kernelExtensionFactory);
        }
        catch (Throwable throwable) {
            throw new LifecycleException(extension, LifecycleStatus.NONE, LifecycleStatus.INITIALIZING, throwable);
        }
        this.life.add(extension);
    }

    public synchronized void removeKernelExtension(KernelExtensionFactory kernelExtensionFactory) {
        Lifecycle extension = this.extensions.remove(kernelExtensionFactory.getKeys());
        if (extension != null) {
            this.kernelExtensionFactories.remove(kernelExtensionFactory);
            this.life.remove(extension);
        }
    }

    public void addKernelExtensionListener(KernelExtensionListener listener) {
        this.listeners = Listeners.addListener(listener, this.listeners);
        if (this.life.getStatus().equals((Object)LifecycleStatus.STARTED)) {
            for (Lifecycle extension : this.life.getLifecycleInstances()) {
                listener.startedKernelExtension(extension);
            }
        }
    }

    public void removeKernelExtensionListener(KernelExtensionListener listener) {
        this.listeners = Listeners.removeListener(listener, this.listeners);
    }

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy<T> selector) throws IllegalArgumentException {
        Iterable<Lifecycle> lifecycleInstances = this.life.getLifecycleInstances();
        Iterable<Lifecycle> filteredInstances = Iterables.filter(new TypeFilter<T>(type), lifecycleInstances);
        Iterable mappedInstances = Iterables.map(new CastFunction<T>(type), filteredInstances);
        return selector.select(type, mappedInstances);
    }

    private Object getKernelExtensionDependencies(KernelExtensionFactory<?> factory) {
        Class configurationClass = (Class)((ParameterizedType)factory.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return Proxy.newProxyInstance(configurationClass.getClassLoader(), new Class[]{configurationClass}, (InvocationHandler)new KernelExtensionHandler());
    }

    static class UnsatisfiedDepencyException
    extends RuntimeException {
        public UnsatisfiedDepencyException(Throwable cause) {
            super(cause);
        }
    }

    private class CastFunction<T>
    implements Function<Object, T> {
        private final Class<T> type;

        public CastFunction(Class<T> type) {
            this.type = type;
        }

        @Override
        public T apply(Object o) {
            return this.type.cast(o);
        }
    }

    private class KernelExtensionHandler
    implements InvocationHandler {
        private KernelExtensionHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return KernelExtensions.this.dependencyResolver.resolveDependency(method.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw new UnsatisfiedDepencyException(e);
            }
        }
    }

    private static class TypeFilter<T>
    implements Predicate {
        private final Class<T> type;

        public TypeFilter(Class<T> type) {
            this.type = type;
        }

        public boolean accept(Object extension) {
            return this.type.isInstance(extension);
        }
    }
}

