/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterable;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.DelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public class RuleUpdateFilterIndexProxy
extends DelegatingIndexProxy {
    private final Predicate<NodePropertyUpdate> ruleMatchingUpdates = new Predicate<NodePropertyUpdate>(){
        private final IndexDescriptor descriptor;
        {
            this.descriptor = RuleUpdateFilterIndexProxy.this.getDescriptor();
        }

        @Override
        public boolean accept(NodePropertyUpdate item) {
            return item.getPropertyKeyId() == this.descriptor.getPropertyKeyId() && item.forLabel(this.descriptor.getLabelId());
        }
    };

    public RuleUpdateFilterIndexProxy(IndexProxy delegate) {
        super(delegate);
    }

    @Override
    public void update(Iterable<NodePropertyUpdate> updates) throws IOException {
        super.update(new FilteringIterable<NodePropertyUpdate>(updates, this.ruleMatchingUpdates));
    }

    @Override
    public void recover(Iterable<NodePropertyUpdate> updates) throws IOException {
        super.recover(new FilteringIterable<NodePropertyUpdate>(updates, this.ruleMatchingUpdates));
    }
}

