/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.FunctionFromPrimitiveLong;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.DataStatement;
import org.neo4j.kernel.api.ReadStatement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.operations.StatementTokenNameLookup;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.SafeProperty;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.constraints.ConstraintValidationKernelException;
import org.neo4j.kernel.impl.cleanup.CleanupService;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;

public class NodeProxy
implements Node {
    private final NodeLookup nodeLookup;
    private final ThreadToStatementContextBridge statementCtxProvider;
    private final long nodeId;

    NodeProxy(long nodeId, NodeLookup nodeLookup, ThreadToStatementContextBridge statementCtxProvider) {
        this.nodeId = nodeId;
        this.nodeLookup = nodeLookup;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeLookup.getGraphDatabase();
    }

    @Override
    public void delete() {
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            statement.nodeDelete(this.getId());
        }
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager());
    }

    @Override
    public boolean hasRelationship() {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getSingleRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    private void assertInTransaction() {
        this.statementCtxProvider.assertInTransaction();
    }

    @Override
    public void setProperty(String key, Object value) {
        boolean requireRollback = true;
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long propertyKeyId = statement.propertyKeyGetOrCreateForName(key);
            try {
                statement.nodeSetProperty(this.nodeId, Property.property(propertyKeyId, value));
            }
            catch (ConstraintValidationKernelException e) {
                requireRollback = false;
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement)), e);
            }
            requireRollback = false;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        finally {
            if (requireRollback) {
                this.nodeLookup.getNodeManager().setRollbackOnly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) throws NotFoundException {
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long propertyKeyId = statement.propertyKeyGetOrCreateForName(key);
            Object object = statement.nodeRemoveProperty(this.nodeId, propertyKeyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyKeyId = statement.propertyKeyGetForName(key);
            Object object = statement.nodeGetProperty(this.nodeId, propertyKeyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Object> getPropertyValues() {
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            Set<Object> set = IteratorUtil.asSet(Iterables.map(new Function<SafeProperty, Object>(){

                @Override
                public Object apply(SafeProperty prop) {
                    return prop.value();
                }
            }, statement.nodeGetAllProperties(this.getId())));
            return set;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<SafeProperty> properties = statement.nodeGetAllProperties(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyKeyId = statement.propertyKeyGetForName(key);
            if (propertyKeyId == -1L) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.nodeGetProperty(this.nodeId, propertyKeyId).value();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long propertyKeyId = statement.propertyKeyGetForName(key);
            boolean bl = statement.nodeGetProperty(this.nodeId, propertyKeyId).isDefined();
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long relationshipTypeId = statement.relationshipTypeGetOrCreateForName(type.name());
            RelationshipProxy relationshipProxy = this.nodeLookup.getNodeManager().newRelationshipProxyById(statement.relationshipCreate(relationshipTypeId, this.nodeId, otherNode.getId()));
            return relationshipProxy;
        }
        catch (RelationshipTypeIdNotFoundKernelException | IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    @Override
    public void addLabel(Label label) {
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            try {
                statement.nodeAddLabel(this.getId(), statement.labelGetOrCreateForName(label.name()));
            }
            catch (ConstraintValidationKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement)), e);
            }
        }
        catch (IllegalTokenNameException e) {
            throw new ConstraintViolationException(String.format("Invalid label name '%s'.", label.name()), e);
        }
        catch (TooManyLabelsException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
    }

    @Override
    public void removeLabel(Label label) {
        try (DataStatement statement = this.statementCtxProvider.dataStatement();){
            long labelId = statement.labelGetForName(label.name());
            if (labelId != -1L) {
                statement.nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasLabel(Label label) {
        try (ReadStatement statement = this.statementCtxProvider.readStatement();){
            long labelId = statement.labelGetForName(label.name());
            boolean bl = statement.nodeHasLabel(this.getId(), labelId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    @Override
    public ResourceIterable<Label> getLabels() {
        return new ResourceIterable<Label>(){

            @Override
            public ResourceIterator<Label> iterator() {
                PrimitiveLongIterator labels;
                final ReadStatement statement = NodeProxy.this.statementCtxProvider.readStatement();
                try {
                    labels = statement.nodeGetLabels(NodeProxy.this.getId());
                }
                catch (EntityNotFoundException e) {
                    statement.close();
                    throw new NotFoundException("No node with id " + NodeProxy.this.getId() + " found.", e);
                }
                return NodeProxy.this.nodeLookup.getCleanupService().resourceIterator(Iterables.map(new FunctionFromPrimitiveLong<Label>(){

                    @Override
                    public Label apply(long labelId) {
                        try {
                            return DynamicLabel.label(statement.labelGetName(labelId));
                        }
                        catch (LabelNotFoundKernelException e) {
                            throw new ThisShouldNotHappenError("Mattias", "Listed labels for node " + NodeProxy.this.nodeId + ", but the returned label " + labelId + " doesn't exist anymore");
                        }
                    }
                }, labels), statement);
            }
        };
    }

    public static interface NodeLookup {
        public NodeImpl lookup(long var1);

        public GraphDatabaseService getGraphDatabase();

        public NodeManager getNodeManager();

        public CleanupService getCleanupService();

        public NodeImpl lookup(long var1, LockType var3);
    }
}

