/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.impl.nioneo.store.Abstract64BitRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class PropertyRecord
extends Abstract64BitRecord {
    private long nextProp = Record.NO_NEXT_PROPERTY.intValue();
    private long prevProp = Record.NO_PREVIOUS_PROPERTY.intValue();
    private final List<PropertyBlock> blockRecords = new ArrayList<PropertyBlock>(4);
    private long entityId = -1L;
    private Boolean nodeIdSet;
    private boolean isChanged;
    private final List<DynamicRecord> deletedRecords = new LinkedList<DynamicRecord>();

    public PropertyRecord(long id) {
        super(id);
    }

    public PropertyRecord(long id, PrimitiveRecord primitive) {
        super(id);
        this.setCreated();
        primitive.setIdTo(this);
    }

    public void setNodeId(long nodeId) {
        this.nodeIdSet = true;
        this.entityId = nodeId;
    }

    public void setRelId(long relId) {
        this.nodeIdSet = false;
        this.entityId = relId;
    }

    public boolean isNodeSet() {
        return Boolean.TRUE.equals(this.nodeIdSet);
    }

    public boolean isRelSet() {
        return Boolean.FALSE.equals(this.nodeIdSet);
    }

    public long getNodeId() {
        if (this.isNodeSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public long getRelId() {
        if (this.isRelSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public int size() {
        int result = 0;
        for (PropertyBlock blockRecord : this.blockRecords) {
            result += blockRecord.getSize();
        }
        return result;
    }

    public List<PropertyBlock> getPropertyBlocks() {
        return this.blockRecords;
    }

    public List<DynamicRecord> getDeletedRecords() {
        return this.deletedRecords;
    }

    public void addDeletedRecord(DynamicRecord record) {
        assert (!record.inUse());
        this.deletedRecords.add(record);
    }

    public void addPropertyBlock(PropertyBlock block) {
        assert (this.size() + block.getSize() <= PropertyType.getPayloadSize()) : "Exceeded capacity of property record " + this + ". My current size is reported as " + this.size() + "The added block was " + block + " (note that size is " + block.getSize() + ")";
        this.blockRecords.add(block);
    }

    public PropertyBlock getPropertyBlock(int keyIndex) {
        for (PropertyBlock block : this.blockRecords) {
            if (block.getKeyIndexId() != keyIndex) continue;
            return block;
        }
        return null;
    }

    public PropertyBlock removePropertyBlock(int keyIndex) {
        for (int i = 0; i < this.blockRecords.size(); ++i) {
            if (this.blockRecords.get(i).getKeyIndexId() != keyIndex) continue;
            return this.blockRecords.remove(i);
        }
        return null;
    }

    public long getNextProp() {
        return this.nextProp;
    }

    public void setNextProp(long nextProp) {
        this.nextProp = nextProp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Property[").append(this.getId()).append(",used=").append(this.inUse()).append(",prev=").append(this.prevProp).append(",next=").append(this.nextProp);
        if (this.entityId != -1L) {
            buf.append(this.nodeIdSet != false ? ",node=" : ",rel=").append(this.entityId);
        }
        for (PropertyBlock block : this.blockRecords) {
            buf.append(',').append(block);
        }
        for (DynamicRecord dyn : this.deletedRecords) {
            buf.append(",del:").append(dyn);
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(PrimitiveRecord primitive) {
        this.isChanged = true;
        primitive.setIdTo(this);
    }

    public long getPrevProp() {
        return this.prevProp;
    }

    public void setPrevProp(long prev) {
        this.prevProp = prev;
    }

    @Override
    public PropertyRecord clone() {
        PropertyRecord result = new PropertyRecord(this.getLongId());
        result.setInUse(this.inUse());
        result.nextProp = this.nextProp;
        result.prevProp = this.prevProp;
        result.entityId = this.entityId;
        result.nodeIdSet = this.nodeIdSet;
        result.isChanged = this.isChanged;
        for (PropertyBlock block : this.blockRecords) {
            result.blockRecords.add(block.clone());
        }
        for (DynamicRecord deletedRecord : this.deletedRecords) {
            result.deletedRecords.add(deletedRecord.clone());
        }
        return result;
    }
}

