/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.SillyUtils;
import org.neo4j.helpers.Thunk;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.BridgingCacheAccess;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.operations.TokenNameLookup;
import org.neo4j.kernel.api.scan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.LockStripedCache;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.nioneo.xa.InterceptingWriteTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.persistence.IdGenerationFailedException;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;

public class NeoStoreXaDataSource
extends LogBackedXaDataSource {
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    public static final byte[] BRANCH_ID = UTF8.encode("414141");
    public static final String LOGICAL_LOG_DEFAULT_NAME = "nioneo_logical.log";
    private final StoreFactory storeFactory;
    private final XaFactory xaFactory;
    private final JobScheduler scheduler;
    private final UpdateableSchemaState updateableSchemaState;
    private final Config config;
    private LifeSupport life;
    private NeoStore neoStore;
    private IndexingService indexingService;
    private DefaultSchemaIndexProviderMap providerMap;
    private XaContainer xaContainer;
    private ArrayMap<Class<?>, Store> idGenerators;
    private File storeDir;
    private boolean readOnly;
    private final TransactionInterceptorProviders providers;
    private boolean logApplied = false;
    private final StringLogger msgLog;
    private final TransactionStateFactory stateFactory;
    private CacheAccessBackDoor cacheAccess;
    private PersistenceCache persistenceCache;
    private SchemaCache schemaCache;
    private final Logging logging;
    private final TokenNameLookup tokenNameLookup;
    private final DependencyResolver dependencyResolver;
    private LabelScanStore labelScanStore;

    public NeoStoreXaDataSource(Config config, StoreFactory sf, StringLogger stringLogger, XaFactory xaFactory, TransactionStateFactory stateFactory, TransactionInterceptorProviders providers, JobScheduler scheduler, Logging logging, UpdateableSchemaState updateableSchemaState, NodeManager nodeManager, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver) {
        super(BRANCH_ID, DEFAULT_DATA_SOURCE_NAME);
        this.config = config;
        this.stateFactory = stateFactory;
        this.tokenNameLookup = tokenNameLookup;
        this.dependencyResolver = dependencyResolver;
        this.providers = providers;
        this.scheduler = scheduler;
        this.logging = logging;
        this.readOnly = config.get(Configuration.read_only);
        this.msgLog = stringLogger;
        this.storeFactory = sf;
        this.xaFactory = xaFactory;
        this.updateableSchemaState = updateableSchemaState;
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.life = new LifeSupport();
        this.readOnly = this.config.get(Configuration.read_only);
        this.storeDir = this.config.get(Configuration.store_dir);
        File store = this.config.get(Configuration.neo_store);
        this.storeFactory.ensureStoreExists();
        TransactionFactory tf = this.providers.shouldInterceptCommitting() ? new InterceptingTransactionFactory() : new TransactionFactory();
        this.neoStore = this.storeFactory.newNeoStore(store);
        this.schemaCache = new SchemaCache(Collections.emptyList());
        final NodeManager nodeManager = this.dependencyResolver.resolveDependency(NodeManager.class);
        Iterator<Cache<?>> caches = nodeManager.caches().iterator();
        this.persistenceCache = new PersistenceCache((LockStripedCache)caches.next(), (LockStripedCache)caches.next(), new Thunk<GraphPropertiesImpl>(){

            @Override
            public GraphPropertiesImpl evaluate() {
                return nodeManager.getGraphProperties();
            }
        });
        this.cacheAccess = new BridgingCacheAccess(nodeManager, this.schemaCache, this.updateableSchemaState, this.persistenceCache);
        SchemaIndexProvider indexProvider = this.dependencyResolver.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        this.providerMap = new DefaultSchemaIndexProviderMap(indexProvider);
        this.indexingService = this.life.add(new IndexingService(this.scheduler, this.providerMap, new NeoStoreIndexStoreView(this.neoStore), this.tokenNameLookup, this.updateableSchemaState, this.logging));
        this.xaContainer = this.xaFactory.newXaContainer(this, this.config.get(Configuration.logical_log), new CommandFactory(this.neoStore, this.indexingService), tf, this.stateFactory, this.providers);
        this.labelScanStore = this.life.add(this.dependencyResolver.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore());
        this.life.init();
        try {
            if (!this.readOnly) {
                this.neoStore.setRecoveredStatus(true);
                try {
                    this.indexingService.initIndexes(this.loadIndexRules());
                    this.xaContainer.openLogicalLog();
                }
                finally {
                    this.neoStore.setRecoveredStatus(false);
                }
            }
            if (!this.xaContainer.getResourceManager().hasRecoveredTransactions()) {
                this.neoStore.makeStoreOk();
            } else {
                this.msgLog.debug("Waiting for TM to take care of recovered transactions.");
            }
            this.idGenerators = new ArrayMap(5, false, false);
            this.idGenerators.put(Node.class, this.neoStore.getNodeStore());
            this.idGenerators.put(Relationship.class, this.neoStore.getRelationshipStore());
            this.idGenerators.put(RelationshipType.class, this.neoStore.getRelationshipTypeStore());
            this.idGenerators.put(Label.class, this.neoStore.getLabelTokenStore());
            this.idGenerators.put(PropertyStore.class, this.neoStore.getPropertyStore());
            this.idGenerators.put(PropertyKeyTokenRecord.class, this.neoStore.getPropertyStore().getPropertyKeyTokenStore());
            this.setLogicalLogAtCreationTime(this.xaContainer.getLogicalLog());
            this.life.start();
        }
        catch (Throwable e) {
            try {
                this.neoStore.close();
            }
            catch (Exception closeException) {
                this.msgLog.logMessage("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
    }

    public NeoStore getNeoStore() {
        return this.neoStore;
    }

    public IndexingService getIndexService() {
        return this.indexingService;
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public DefaultSchemaIndexProviderMap getProviderMap() {
        return this.providerMap;
    }

    public SchemaCache getSchemaCache() {
        return this.schemaCache;
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.readOnly) {
            this.forceEverything();
        }
        this.life.shutdown();
        this.xaContainer.close();
        if (this.logApplied) {
            this.neoStore.rebuildIdGenerators();
            this.logApplied = false;
        }
        this.neoStore.close();
        this.msgLog.info("NeoStore closed");
    }

    private void forceEverything() {
        this.neoStore.flushAll();
        this.indexingService.flushAll();
        this.labelScanStore.force();
    }

    @Override
    public void shutdown() {
    }

    public StoreId getStoreId() {
        return this.neoStore.getStoreId();
    }

    @Override
    public NeoStoreXaConnection getXaConnection() {
        return new NeoStoreXaConnection(this.neoStore, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    public long nextId(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.nextId();
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getHighestPossibleIdInUse();
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getNumberOfIdsInUse();
    }

    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    @Override
    public long getCreationTime() {
        return this.neoStore.getCreationTime();
    }

    @Override
    public long getRandomIdentifier() {
        return this.neoStore.getRandomNumber();
    }

    @Override
    public long getCurrentLogVersion() {
        return this.neoStore.getVersion();
    }

    public long incrementAndGetLogVersion() {
        return this.neoStore.incrementVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastCommittedTxId(long txId) {
        this.neoStore.setRecoveredStatus(true);
        try {
            this.neoStore.setLastCommittedTx(txId);
        }
        finally {
            this.neoStore.setRecoveredStatus(false);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<WindowPoolStats> getWindowPoolStats() {
        return this.neoStore.getAllWindowPoolStats();
    }

    @Override
    public long getLastCommittedTxId() {
        return this.neoStore.getLastCommittedTx();
    }

    @Override
    public XaContainer getXaContainer() {
        return this.xaContainer;
    }

    @Override
    public boolean setRecovered(boolean recovered) {
        boolean currentValue = this.neoStore.isInRecoveryMode();
        this.neoStore.setRecoveredStatus(true);
        return currentValue;
    }

    @Override
    public ResourceIterator<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.gatherNeoStoreFiles(includeLogicalLogs, files);
        Closeable labelScanStoreSnapshot = this.gatherLabelScanStoreFiles(files);
        return new StoreSnapshot(files.iterator(), labelScanStoreSnapshot);
    }

    private Closeable gatherLabelScanStoreFiles(Collection<File> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.labelScanStore.snapshotStoreFiles();
        while (snapshot.hasNext()) {
            targetFiles.add((File)snapshot.next());
        }
        return snapshot;
    }

    private void gatherNeoStoreFiles(boolean includeLogicalLogs, Collection<File> targetFiles) {
        File neostoreFile = null;
        Pattern logFilePattern = this.getXaContainer().getLogicalLog().getHistoryFileNamePattern();
        for (File dbFile : SillyUtils.nonNull(this.storeDir.listFiles())) {
            String name = dbFile.getName();
            if (!dbFile.isFile()) continue;
            if (name.equals("neostore")) {
                neostoreFile = dbFile;
                continue;
            }
            if ((name.startsWith("neostore") || name.equals("index.db")) && !name.endsWith(".id")) {
                targetFiles.add(dbFile);
                continue;
            }
            if (!includeLogicalLogs || !logFilePattern.matcher(dbFile.getName()).matches()) continue;
            targetFiles.add(dbFile);
        }
        targetFiles.add(neostoreFile);
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        manager.registerAll(Diagnostics.class, this);
    }

    private Iterator<IndexRule> loadIndexRules() {
        return Iterables.map(new Function<SchemaRule, IndexRule>(){

            @Override
            public IndexRule apply(SchemaRule schemaRule) {
                return (IndexRule)schemaRule;
            }
        }, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind().isIndex();
            }
        }, this.neoStore.getSchemaStore().loadAllSchemaRules()));
    }

    public PersistenceCache getPersistenceCache() {
        return this.persistenceCache;
    }

    private static class StoreSnapshot
    extends PrefetchingIterator<File>
    implements ResourceIterator<File> {
        private final Iterator<File> files;
        private final Closeable closeable;

        StoreSnapshot(Iterator<File> files, Closeable closeable) {
            this.files = files;
            this.closeable = closeable;
        }

        @Override
        protected File fetchNextOrNull() {
            return this.files.hasNext() ? this.files.next() : null;
        }

        @Override
        public void close() {
            try {
                this.closeable.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class TransactionFactory
    extends XaTransactionFactory {
        private TransactionFactory() {
        }

        @Override
        public XaTransaction create(int identifier, TransactionState state) {
            return new WriteTransaction(identifier, this.getLogicalLog(), state, NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.cacheAccess, NeoStoreXaDataSource.this.indexingService, NeoStoreXaDataSource.this.labelScanStore);
        }

        @Override
        public void recoveryComplete() {
            NeoStoreXaDataSource.this.msgLog.debug("Recovery complete, all transactions have been resolved");
            NeoStoreXaDataSource.this.msgLog.debug("Rebuilding id generators as needed. This can take a while for large stores...");
            NeoStoreXaDataSource.this.forceEverything();
            NeoStoreXaDataSource.this.neoStore.makeStoreOk();
            NeoStoreXaDataSource.this.neoStore.setVersion(NeoStoreXaDataSource.this.xaContainer.getLogicalLog().getHighestLogVersion());
            NeoStoreXaDataSource.this.msgLog.debug("Rebuild of id generators complete.");
        }

        @Override
        public long getCurrentVersion() {
            return NeoStoreXaDataSource.this.neoStore.getVersion();
        }

        @Override
        public long getAndSetNewVersion() {
            return NeoStoreXaDataSource.this.neoStore.incrementVersion();
        }

        @Override
        public void setVersion(long version) {
            NeoStoreXaDataSource.this.neoStore.setVersion(version);
        }

        @Override
        public void flushAll() {
            NeoStoreXaDataSource.this.forceEverything();
        }

        @Override
        public long getLastCommittedTx() {
            return NeoStoreXaDataSource.this.neoStore.getLastCommittedTx();
        }
    }

    private class InterceptingTransactionFactory
    extends TransactionFactory {
        private InterceptingTransactionFactory() {
        }

        @Override
        public XaTransaction create(int identifier, TransactionState state) {
            TransactionInterceptor first = NeoStoreXaDataSource.this.providers.resolveChain(NeoStoreXaDataSource.this);
            return new InterceptingWriteTransaction(identifier, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, state, NeoStoreXaDataSource.this.cacheAccess, NeoStoreXaDataSource.this.indexingService, NeoStoreXaDataSource.this.labelScanStore, first);
        }
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private final NeoStore neoStore;
        private final IndexingService indexingService;

        CommandFactory(NeoStore neoStore, IndexingService indexingService) {
            this.neoStore = neoStore;
            this.indexingService = indexingService;
        }

        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(this.neoStore, this.indexingService, byteChannel, buffer);
        }
    }

    private static enum Diagnostics implements DiagnosticsExtractor<NeoStoreXaDataSource>
    {
        NEO_STORE_VERSIONS("Store versions:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logVersions(log);
            }
        }
        ,
        NEO_STORE_ID_USAGE("Id usage:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logIdUsage(log);
            }
        }
        ,
        PERSISTENCE_WINDOW_POOL_STATS("Persistence Window Pool stats:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logAllWindowPoolStats(log);
            }

            @Override
            boolean applicable(DiagnosticsPhase phase) {
                return phase.isExplicitlyRequested();
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(final NeoStoreXaDataSource source, DiagnosticsPhase phase, StringLogger log) {
            if (this.applicable(phase)) {
                log.logLongMessage(this.message, new Visitor<StringLogger.LineLogger, RuntimeException>(){

                    @Override
                    public boolean visit(StringLogger.LineLogger logger) {
                        Diagnostics.this.dump(source, logger);
                        return false;
                    }
                }, true);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreXaDataSource var1, StringLogger.LineLogger var2);
    }

    public static abstract class Configuration
    extends LogBackedXaDataSource.Configuration {
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
        public static final Setting<File> logical_log = InternalAbstractGraphDatabase.Configuration.logical_log;
    }
}

