/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.monitoring;

import java.io.PrintStream;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.util.StringLogger;

public class VisibleMigrationProgressMonitor
implements MigrationProgressMonitor {
    private final StringLogger logger;
    private final PrintStream out;

    public VisibleMigrationProgressMonitor(StringLogger logger, PrintStream out) {
        this.logger = logger;
        this.out = out;
    }

    @Override
    public void started() {
        String message = "Starting upgrade of database store files";
        this.out.println(message);
        this.logger.logMessage(message, true);
    }

    @Override
    public void percentComplete(int percent) {
        this.out.print(".");
        this.out.flush();
        if (percent % 10 == 0) {
            this.logger.logMessage(String.format("Store upgrade %d%% complete", percent), true);
        }
    }

    @Override
    public void finished() {
        String message = "Finished upgrade of database store files";
        this.out.println();
        this.out.println(message);
        this.logger.logMessage(message, true);
    }
}

