/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class CombinedRelIdIterator
implements RelIdIterator {
    private RelIdIterator srcIterator;
    private final RelIdIterator addIterator;
    private RelIdIterator currentIterator;
    private final Collection<Long> removed;
    private final int type;
    private boolean nextElementDetermined;
    private long nextElement;

    public CombinedRelIdIterator(int type, RelIdArray.DirectionWrapper direction, RelIdArray src, RelIdArray add, Collection<Long> remove) {
        this.type = type;
        this.srcIterator = src != null ? src.iterator(direction) : RelIdArray.EMPTY.iterator(direction);
        this.addIterator = add != null ? add.iterator(direction) : RelIdArray.EMPTY.iterator(direction);
        this.currentIterator = this.srcIterator;
        this.removed = remove;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public RelIdIterator updateSource(RelIdArray newSource, RelIdArray.DirectionWrapper direction) {
        this.srcIterator = this.srcIterator.updateSource(newSource, direction);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextElementDetermined) {
            return this.nextElement != -1L;
        }
        while (this.currentIterator.hasNext() || this.currentIterator != this.addIterator) {
            while (this.currentIterator.hasNext()) {
                long value = this.currentIterator.next();
                if (this.removed != null && this.removed.contains(value)) continue;
                this.nextElement = value;
                this.nextElementDetermined = true;
                return true;
            }
            this.currentIterator = this.addIterator;
        }
        this.nextElementDetermined = true;
        this.nextElement = -1L;
        return false;
    }

    @Override
    public void doAnotherRound() {
        this.srcIterator.doAnotherRound();
        this.addIterator.doAnotherRound();
        this.nextElementDetermined = false;
        this.currentIterator = this.srcIterator;
    }

    @Override
    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextElementDetermined = false;
        return this.nextElement;
    }
}

