/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.DaemonThreadFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Neo4jJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private final StringLogger log;
    private final String id;
    private ExecutorService executor;
    private Timer timer;

    public Neo4jJobScheduler(StringLogger log) {
        this.log = log;
        this.id = this.getClass().getSimpleName();
    }

    public Neo4jJobScheduler(String id, StringLogger log) {
        this.log = log;
        this.id = id;
    }

    @Override
    public void start() {
        this.executor = Executors.newCachedThreadPool(new DaemonThreadFactory("Neo4j " + this.id));
        this.timer = new Timer("Neo4j Recurring Job Runner", true);
    }

    @Override
    public void schedule(Runnable job) {
        this.executor.submit(job);
    }

    @Override
    public void scheduleRecurring(final Runnable runnable, long period, TimeUnit timeUnit) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (RuntimeException e) {
                    Neo4jJobScheduler.this.log.error("Failed running recurring job.", e);
                }
            }
        }, 0L, timeUnit.toMillis(period));
    }

    @Override
    public void stop() {
        RuntimeException exception = null;
        try {
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        try {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (exception != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }
}

