/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;

public interface IndexAccessor
extends Closeable {
    public void drop() throws IOException;

    public IndexUpdater newUpdater(IndexUpdateMode var1);

    public void force() throws IOException;

    @Override
    public void close() throws IOException;

    public IndexReader newReader();

    public BoundedIterable<Long> newAllEntriesReader();

    public ResourceIterator<File> snapshotFiles() throws IOException;

    public static class Adapter
    implements IndexAccessor {
        @Override
        public void drop() {
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void force() {
        }

        @Override
        public void close() {
        }

        @Override
        public IndexReader newReader() {
            return IndexReader.EMPTY;
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader() {
            return new BoundedIterable<Long>(){

                @Override
                public long maxCount() {
                    return 0L;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<Long> iterator() {
                    return IteratorUtil.emptyIterator();
                }
            };
        }

        @Override
        public ResourceIterator<File> snapshotFiles() {
            return IteratorUtil.emptyIterator();
        }
    }
}

