/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.DefaultLegacyKernelOperations;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.LockHolderImpl;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.NoOpJTATransaction;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.operations.LegacyKernelOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.Transactor;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final AbstractTransactionManager transactionManager;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final PersistenceManager persistenceManager;
    private final LockManager lockManager;
    private final UpdateableSchemaState schemaState;
    private final SchemaWriteGuard schemaWriteGuard;
    private final IndexingService indexService;
    private final NeoStore neoStore;
    private final Provider<NeoStore> neoStoreProvider;
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final SchemaIndexProviderMap providerMap;
    private final LabelScanStore labelScanStore;
    private final NodeManager nodeManager;
    private final LegacyKernelOperations legacyKernelOperations;
    private final StatementOperationParts statementOperations;
    private final boolean readOnly;
    private final LegacyPropertyTrackers legacyPropertyTrackers;
    private boolean isShutdown = false;

    public Kernel(AbstractTransactionManager transactionManager, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, PersistenceManager persistenceManager, LockManager lockManager, UpdateableSchemaState schemaState, SchemaWriteGuard schemaWriteGuard, IndexingService indexService, NodeManager nodeManager, Provider<NeoStore> neoStore, PersistenceCache persistenceCache, SchemaCache schemaCache, SchemaIndexProviderMap providerMap, LabelScanStore labelScanStore, boolean readOnly) {
        this.transactionManager = transactionManager;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.persistenceManager = persistenceManager;
        this.lockManager = lockManager;
        this.schemaState = schemaState;
        this.providerMap = providerMap;
        this.readOnly = readOnly;
        this.schemaWriteGuard = schemaWriteGuard;
        this.indexService = indexService;
        this.neoStore = neoStore.instance();
        this.neoStoreProvider = neoStore;
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
        this.labelScanStore = labelScanStore;
        this.nodeManager = nodeManager;
        this.legacyPropertyTrackers = new LegacyPropertyTrackers(propertyKeyTokenHolder, nodeManager.getNodePropertyTrackers(), nodeManager.getRelationshipPropertyTrackers(), nodeManager);
        this.legacyKernelOperations = new DefaultLegacyKernelOperations(nodeManager);
        this.statementOperations = this.buildStatementOperations();
    }

    @Override
    public void start() {
        this.loadSchemaCache();
    }

    public void loadSchemaCache() {
        this.schemaCache.clear();
        for (SchemaRule schemaRule : IteratorUtil.loop(this.neoStore.getSchemaStore().loadAllSchemaRules())) {
            this.schemaCache.addSchemaRule(schemaRule);
        }
    }

    @Override
    public void stop() {
        this.isShutdown = true;
    }

    @Override
    public KernelTransaction newTransaction() {
        this.checkIfShutdown();
        return new KernelTransactionImplementation(this.statementOperations, this.legacyKernelOperations, this.readOnly, this.schemaWriteGuard, this.labelScanStore, this.indexService, this.transactionManager, this.nodeManager, this.schemaState, new LockHolderImpl(this.lockManager, this.getJTATransaction(), this.nodeManager), this.persistenceManager, this.providerMap, this.neoStore, this.getLegacyTxState());
    }

    private TransactionState getLegacyTxState() {
        try {
            TransactionState legacyState = this.transactionManager.getTransactionState();
            return legacyState != null ? legacyState : TransactionState.NO_STATE;
        }
        catch (RuntimeException e) {
            return TransactionState.NO_STATE;
        }
    }

    private Transaction getJTATransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            return new NoOpJTATransaction();
        }
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    private StatementOperationParts buildStatementOperations() {
        CacheLayer storeLayer = new CacheLayer(new DiskLayer(this.propertyKeyTokenHolder, this.labelTokenHolder, this.relationshipTypeTokenHolder, new SchemaStorage(this.neoStore.getSchemaStore()), this.neoStoreProvider, this.indexService), this.persistenceCache, this.indexService, this.schemaCache);
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(storeLayer, this.legacyPropertyTrackers, new ConstraintIndexCreator(new Transactor(this.transactionManager, this.persistenceManager), this.indexService));
        StatementOperationParts parts = new StatementOperationParts(stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(this.schemaState));
        ConstraintEnforcingEntityOperations constraintEnforcingEntityOperations = new ConstraintEnforcingEntityOperations(parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations());
        parts = parts.override(null, dataIntegrityContext, constraintEnforcingEntityOperations, constraintEnforcingEntityOperations, null, dataIntegrityContext, null, new Object[0]);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, new Object[0]);
        return parts;
    }
}

