/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.helpers.ValueGetter;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class IndexPopulationJob
implements Runnable {
    private final IndexStoreView storeView;
    private final String indexUserDescription;
    private final Queue<NodePropertyUpdate> queue = new ConcurrentLinkedQueue<NodePropertyUpdate>();
    private final IndexDescriptor descriptor;
    private final FailedIndexProxyFactory failureDelegate;
    private IndexingService.Monitor monitor;
    private final IndexPopulator populator;
    private final FlippableIndexProxy flipper;
    private final UpdateableSchemaState updateableSchemaState;
    private final StringLogger log;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private volatile StoreScan<IndexPopulationFailedKernelException> storeScan;
    private volatile boolean cancelled;
    private final SchemaIndexProvider.Descriptor providerDescriptor;

    public IndexPopulationJob(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, String indexUserDescription, FailedIndexProxyFactory failureDelegateFactory, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, UpdateableSchemaState updateableSchemaState, Logging logging, IndexingService.Monitor monitor) {
        this.descriptor = descriptor;
        this.providerDescriptor = providerDescriptor;
        this.populator = populator;
        this.flipper = flipper;
        this.storeView = storeView;
        this.updateableSchemaState = updateableSchemaState;
        this.indexUserDescription = indexUserDescription;
        this.failureDelegate = failureDelegateFactory;
        this.monitor = monitor;
        this.log = logging.getMessagesLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format("Index populator on %s [runs on: %s]", this.indexUserDescription, oldThreadName));
        boolean success = false;
        Throwable failureCause = null;
        try {
            block25: {
                this.log.info(String.format("Index population started: [%s]", this.indexUserDescription));
                this.log.flush();
                this.populator.create();
                this.indexAllNodes();
                if (!this.cancelled) break block25;
                try {
                    if (success) return;
                    if (failureCause != null) {
                        this.populator.markAsFailed(IndexPopulationFailure.failure(failureCause).asString());
                    }
                    this.populator.close(false);
                    return;
                }
                catch (Throwable e) {
                    this.log.error(String.format("Unable to close failed populator for index: [%s]", this.indexUserDescription), e);
                    this.log.flush();
                }
                return;
            }
            Callable<Void> duringFlip = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IndexPopulationJob.this.populateFromQueueIfAvailable(Long.MAX_VALUE);
                    IndexPopulationJob.this.populator.close(true);
                    IndexPopulationJob.this.updateableSchemaState.clear();
                    return null;
                }
            };
            this.flipper.flip(duringFlip, this.failureDelegate);
            success = true;
            this.log.info(String.format("Index population completed. Index is now online: [%s]", this.indexUserDescription));
            this.log.flush();
            try {
                if (success) return;
                if (failureCause != null) {
                    this.populator.markAsFailed(IndexPopulationFailure.failure(failureCause).asString());
                }
                this.populator.close(false);
                return;
            }
            catch (Throwable e) {
                this.log.error(String.format("Unable to close failed populator for index: [%s]", this.indexUserDescription), e);
                this.log.flush();
            }
            return;
            catch (Throwable t) {
                try {
                    Throwable cause;
                    if (t instanceof IndexPopulationFailedKernelException && (cause = t.getCause()) instanceof IndexEntryConflictException) {
                        t = cause;
                    }
                    if (!(t instanceof IndexEntryConflictException)) {
                        this.log.error(String.format("Failed to populate index: [%s]", this.indexUserDescription), t);
                        this.log.flush();
                    }
                    failureCause = t;
                    this.flipper.flipTo(new FailedIndexProxy(this.descriptor, this.providerDescriptor, this.indexUserDescription, this.populator, IndexPopulationFailure.failure(t), this.log));
                }
                catch (Throwable throwable) {
                    try {
                        if (success) throw throwable;
                        if (failureCause != null) {
                            this.populator.markAsFailed(IndexPopulationFailure.failure(failureCause).asString());
                        }
                        this.populator.close(false);
                        throw throwable;
                    }
                    catch (Throwable e) {
                        this.log.error(String.format("Unable to close failed populator for index: [%s]", this.indexUserDescription), e);
                        this.log.flush();
                    }
                    throw throwable;
                }
                try {
                    if (success) return;
                    if (failureCause != null) {
                        this.populator.markAsFailed(IndexPopulationFailure.failure(failureCause).asString());
                    }
                    this.populator.close(false);
                    return;
                }
                catch (Throwable e) {
                    this.log.error(String.format("Unable to close failed populator for index: [%s]", this.indexUserDescription), e);
                    this.log.flush();
                }
                return;
            }
        }
        finally {
            this.doneSignal.countDown();
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private void indexAllNodes() throws IndexPopulationFailedKernelException {
        this.storeScan = this.storeView.visitNodesWithPropertyAndLabel(this.descriptor, new Visitor<NodePropertyUpdate, IndexPopulationFailedKernelException>(){

            @Override
            public boolean visit(NodePropertyUpdate update) throws IndexPopulationFailedKernelException {
                try {
                    IndexPopulationJob.this.populator.add(update.getNodeId(), update.getValueAfter());
                    IndexPopulationJob.this.populateFromQueueIfAvailable(update.getNodeId());
                }
                catch (IOException | IndexCapacityExceededException | IndexEntryConflictException conflict) {
                    throw new IndexPopulationFailedKernelException(IndexPopulationJob.this.descriptor, IndexPopulationJob.this.indexUserDescription, conflict);
                }
                return false;
            }
        });
        this.storeScan.run();
        this.monitor.verifyDeferredConstraints();
        try {
            this.populator.verifyDeferredConstraints(this.storeView);
        }
        catch (Exception conflict) {
            throw new IndexPopulationFailedKernelException(this.descriptor, this.indexUserDescription, conflict);
        }
    }

    private void populateFromQueueIfAvailable(long highestIndexedNodeId) throws IndexEntryConflictException, IndexCapacityExceededException, IOException {
        if (!this.queue.isEmpty()) {
            try (IndexUpdater updater = this.populator.newPopulatingUpdater(this.storeView);){
                for (NodePropertyUpdate update : this.queue) {
                    if (update.getNodeId() > highestIndexedNodeId) continue;
                    updater.process(update);
                }
            }
        }
    }

    public Future<Void> cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
        }
        return FutureAdapter.latchGuardedValue(ValueGetter.NO_VALUE, this.doneSignal);
    }

    public void update(NodePropertyUpdate update) {
        this.queue.add(update);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.populator + ", descriptor:" + this.indexUserDescription + "]";
    }

    public void awaitCompletion() throws InterruptedException {
        this.doneSignal.await();
    }
}

