/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.BiConsumer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.AggregatedReservation;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.IndexUpdates;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;

public class IndexingService
extends LifecycleAdapter {
    private final IndexMapReference indexMapReference = new IndexMapReference();
    private final JobScheduler scheduler;
    private final SchemaIndexProviderMap providerMap;
    private final IndexStoreView storeView;
    private final TokenNameLookup tokenNameLookup;
    private final Logging logging;
    private final StringLogger logger;
    private final UpdateableSchemaState updateableSchemaState;
    private final Set<Long> recoveredNodeIds = new HashSet<Long>();
    private final Monitor monitor;
    public static final Monitor NO_MONITOR = new MonitorAdapter(){};
    private volatile State state = State.NOT_STARTED;

    public IndexingService(JobScheduler scheduler, SchemaIndexProviderMap providerMap, IndexStoreView storeView, TokenNameLookup tokenNameLookup, UpdateableSchemaState updateableSchemaState, Logging logging, Monitor monitor) {
        this.scheduler = scheduler;
        this.providerMap = providerMap;
        this.storeView = storeView;
        this.logging = logging;
        this.monitor = monitor;
        this.logger = logging.getMessagesLog(this.getClass());
        this.updateableSchemaState = updateableSchemaState;
        this.tokenNameLookup = tokenNameLookup;
        if (providerMap == null || providerMap.getDefaultProvider() == null) {
            throw new IllegalStateException("You cannot run the database without an index provider, please make sure that a valid provider (subclass of " + SchemaIndexProvider.class.getName() + ") is on your classpath.");
        }
    }

    public void initIndexes(Iterator<IndexRule> indexRules) {
        IndexMap indexMap = this.indexMapReference.getIndexMapCopy();
        for (IndexRule indexRule : IteratorUtil.loop(indexRules)) {
            IndexProxy indexProxy;
            long indexId = indexRule.getId();
            IndexDescriptor descriptor = this.createDescriptor(indexRule);
            SchemaIndexProvider.Descriptor providerDescriptor = indexRule.getProviderDescriptor();
            SchemaIndexProvider provider = this.providerMap.apply(providerDescriptor);
            InternalIndexState initialState = provider.getInitialState(indexId);
            this.logger.info(String.format("IndexingService.initIndexes: index on %s is %s", new Object[]{descriptor.userDescription(this.tokenNameLookup), initialState}));
            boolean constraint = indexRule.isConstraintIndex();
            switch (initialState) {
                case ONLINE: {
                    indexProxy = this.createAndStartOnlineIndexProxy(indexId, descriptor, providerDescriptor, constraint);
                    break;
                }
                case POPULATING: {
                    indexProxy = this.createAndStartRecoveringIndexProxy(descriptor, providerDescriptor);
                    break;
                }
                case FAILED: {
                    IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(indexId));
                    indexProxy = this.createAndStartFailedIndexProxy(indexId, descriptor, providerDescriptor, constraint, failure);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("" + (Object)((Object)initialState));
                }
            }
            indexMap.putIndexProxy(indexId, indexProxy);
        }
        this.indexMapReference.setIndexMap(indexMap);
    }

    public void startIndexes() throws IOException {
        this.state = State.STARTING;
        this.applyRecoveredUpdates();
        IndexMap indexMap = this.indexMapReference.getIndexMapCopy();
        final HashMap<Long, Pair<IndexDescriptor, SchemaIndexProvider.Descriptor>> rebuildingDescriptors = new HashMap<Long, Pair<IndexDescriptor, SchemaIndexProvider.Descriptor>>();
        indexMap.foreachIndexProxy(new BiConsumer<Long, IndexProxy>(){

            @Override
            public void accept(Long indexId, IndexProxy indexProxy) {
                InternalIndexState state = indexProxy.getState();
                IndexingService.this.logger.info(String.format("IndexingService.start: index on %s is %s", indexProxy.getDescriptor().userDescription(IndexingService.this.tokenNameLookup), state.name()));
                switch (state) {
                    case ONLINE: {
                        break;
                    }
                    case POPULATING: {
                        rebuildingDescriptors.put(indexId, IndexingService.this.getIndexProxyDescriptors(indexProxy));
                        break;
                    }
                }
            }
        });
        this.dropRecoveringIndexes(indexMap, rebuildingDescriptors);
        for (Map.Entry entry : rebuildingDescriptors.entrySet()) {
            long indexId = (Long)entry.getKey();
            Pair descriptors = (Pair)entry.getValue();
            IndexDescriptor indexDescriptor = (IndexDescriptor)descriptors.first();
            SchemaIndexProvider.Descriptor providerDescriptor = (SchemaIndexProvider.Descriptor)descriptors.other();
            IndexProxy indexProxy = this.createAndStartPopulatingIndexProxy(indexId, indexDescriptor, providerDescriptor, false);
            indexMap.putIndexProxy(indexId, indexProxy);
        }
        this.indexMapReference.setIndexMap(indexMap);
        this.state = State.RUNNING;
    }

    @Override
    public void stop() {
        this.state = State.STOPPED;
        this.closeAllIndexes();
    }

    public IndexProxy getProxyForRule(long indexId) throws IndexNotFoundKernelException {
        IndexProxy indexProxy = this.indexMapReference.getIndexProxy(indexId);
        if (indexProxy == null) {
            throw new IndexNotFoundKernelException("No index with id " + indexId + " exists.");
        }
        return indexProxy;
    }

    public void createIndex(IndexRule rule) {
        long ruleId;
        IndexMap indexMap = this.indexMapReference.getIndexMapCopy();
        IndexProxy index = indexMap.getIndexProxy(ruleId = rule.getId());
        if (index != null && this.state == State.NOT_STARTED) {
            indexMap.putIndexProxy(ruleId, index);
            this.indexMapReference.setIndexMap(indexMap);
            return;
        }
        IndexDescriptor descriptor = this.createDescriptor(rule);
        SchemaIndexProvider.Descriptor providerDescriptor = rule.getProviderDescriptor();
        boolean constraint = rule.isConstraintIndex();
        if (this.state == State.RUNNING) {
            try {
                index = this.createAndStartPopulatingIndexProxy(ruleId, descriptor, providerDescriptor, constraint);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            index = this.createAndStartRecoveringIndexProxy(descriptor, providerDescriptor);
        }
        indexMap.putIndexProxy(rule.getId(), index);
        this.indexMapReference.setIndexMap(indexMap);
    }

    private String indexUserDescription(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        String userDescription = descriptor.userDescription(this.tokenNameLookup);
        return String.format("%s [provider: %s]", userDescription, providerDescriptor.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatedIndexUpdates validate(IndexUpdates updates) {
        IndexUpdateMode updateMode = null;
        if (this.state == State.RUNNING) {
            updateMode = IndexUpdateMode.ONLINE;
        } else if (this.state == State.STARTING) {
            updateMode = IndexUpdateMode.RECOVERY;
        }
        if (updateMode != null) {
            IndexUpdaterMap updaterMap = this.indexMapReference.getIndexUpdaterMap(updateMode);
            boolean updaterMapShouldBeClosed = true;
            try {
                Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex = IndexingService.groupUpdatesByIndexDescriptor(updates, updaterMap);
                if (updatesByIndex.isEmpty()) {
                    ValidatedIndexUpdates validatedIndexUpdates = IndexingService.newValidatedIndexUpdates(updates);
                    return validatedIndexUpdates;
                }
                AggregatedReservation aggregatedReservation = new AggregatedReservation(updatesByIndex.size());
                for (Map.Entry<IndexDescriptor, List<NodePropertyUpdate>> entry : updatesByIndex.entrySet()) {
                    this.validateAndRecordReservation(entry.getValue(), aggregatedReservation, updaterMap, entry.getKey());
                }
                ValidatedIndexUpdates validatedUpdates = IndexingService.newValidatedIndexUpdates(updates, updaterMap, updatesByIndex, aggregatedReservation);
                updaterMapShouldBeClosed = false;
                ValidatedIndexUpdates validatedIndexUpdates = validatedUpdates;
                return validatedIndexUpdates;
            }
            finally {
                if (updaterMapShouldBeClosed) {
                    updaterMap.close();
                }
            }
        }
        return IndexingService.newValidatedIndexUpdates(updates);
    }

    private void validateAndRecordReservation(List<NodePropertyUpdate> indexUpdates, AggregatedReservation aggregatedReservation, IndexUpdaterMap updaterMap, IndexDescriptor descriptor) {
        boolean exceptionThrown = false;
        try {
            IndexUpdater updater = updaterMap.getUpdater(descriptor);
            Reservation reservation = updater.validate(indexUpdates);
            aggregatedReservation.add(reservation);
        }
        catch (IOException | IndexCapacityExceededException e) {
            exceptionThrown = true;
            String indexName = descriptor.userDescription(this.tokenNameLookup);
            throw new UnderlyingStorageException("Validation of updates for index " + indexName + " failed", e);
        }
        catch (Throwable t) {
            exceptionThrown = true;
            throw t;
        }
        finally {
            if (exceptionThrown) {
                aggregatedReservation.release();
            }
        }
    }

    private static ValidatedIndexUpdates newValidatedIndexUpdates(final IndexUpdates indexUpdates) {
        return new ValidatedIndexUpdates(){

            @Override
            public void flush() throws IOException, IndexEntryConflictException {
            }

            @Override
            public Set<Long> changedNodeIds() {
                return indexUpdates.changedNodeIds();
            }

            @Override
            public void close() {
            }
        };
    }

    private static ValidatedIndexUpdates newValidatedIndexUpdates(final IndexUpdates indexUpdates, final IndexUpdaterMap indexUpdaters, final Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex, final Reservation reservation) {
        return new ValidatedIndexUpdates(){

            @Override
            public void flush() throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
                for (Map.Entry entry : updatesByIndex.entrySet()) {
                    IndexDescriptor indexDescriptor = (IndexDescriptor)entry.getKey();
                    List updates = (List)entry.getValue();
                    IndexUpdater updater = indexUpdaters.getUpdater(indexDescriptor);
                    for (NodePropertyUpdate update : updates) {
                        updater.process(update);
                    }
                }
            }

            @Override
            public Set<Long> changedNodeIds() {
                return indexUpdates.changedNodeIds();
            }

            @Override
            public void close() {
                reservation.release();
                indexUpdaters.close();
            }
        };
    }

    public void updateIndexes(ValidatedIndexUpdates updates) {
        if (this.state == State.RUNNING) {
            try {
                updates.flush();
            }
            catch (IOException | IndexCapacityExceededException | IndexEntryConflictException e) {
                throw new UnderlyingStorageException(e);
            }
        } else if (this.state == State.NOT_STARTED) {
            this.recoveredNodeIds.addAll(updates.changedNodeIds());
        } else {
            throw new IllegalStateException("Cannot queue index updates while index service is " + (Object)((Object)this.state));
        }
    }

    protected void applyRecoveredUpdates() throws IOException {
        this.logger.debug("Applying recovered updates: " + this.recoveredNodeIds);
        this.monitor.applyingRecoveredData(this.recoveredNodeIds);
        if (!this.recoveredNodeIds.isEmpty()) {
            try (IndexUpdaterMap updaterMap = this.indexMapReference.getIndexUpdaterMap(IndexUpdateMode.RECOVERY);){
                for (IndexUpdater updater : updaterMap) {
                    updater.remove(this.recoveredNodeIds);
                }
                ArrayList<NodePropertyUpdate> recoveredUpdates = new ArrayList<NodePropertyUpdate>();
                for (long nodeId : this.recoveredNodeIds) {
                    Iterables.addAll(recoveredUpdates, this.storeView.nodeAsUpdates(nodeId));
                }
                try (ValidatedIndexUpdates validatedUpdates = this.validate(IndexingService.asIndexUpdates(recoveredUpdates));){
                    validatedUpdates.flush();
                    this.monitor.appliedRecoveredData(recoveredUpdates);
                }
                catch (IndexCapacityExceededException | IndexEntryConflictException e) {
                    throw new UnderlyingStorageException(e);
                }
            }
        }
        this.recoveredNodeIds.clear();
    }

    private static IndexUpdates asIndexUpdates(final Iterable<NodePropertyUpdate> updates) {
        return new IndexUpdates(){

            @Override
            public Set<Long> changedNodeIds() {
                return Collections.emptySet();
            }

            @Override
            public Iterator<NodePropertyUpdate> iterator() {
                return updates.iterator();
            }
        };
    }

    private static Map<IndexDescriptor, List<NodePropertyUpdate>> groupUpdatesByIndexDescriptor(Iterable<NodePropertyUpdate> updates, IndexUpdaterMap updaterMap) {
        int numberOfIndexes = updaterMap.numberOfIndexes();
        HashMap<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex = new HashMap<IndexDescriptor, List<NodePropertyUpdate>>(numberOfIndexes, 1.0f);
        block5: for (NodePropertyUpdate update : updates) {
            int propertyKeyId = update.getPropertyKeyId();
            switch (update.getUpdateMode()) {
                case ADDED: {
                    int i;
                    int len = update.getNumberOfLabelsAfter();
                    for (i = 0; i < len; ++i) {
                        int labelAfter = update.getLabelAfter(i);
                        IndexingService.storeUpdateIfIndexExists(updaterMap, update, propertyKeyId, labelAfter, updatesByIndex);
                    }
                    continue block5;
                }
                case REMOVED: {
                    int i;
                    int len = update.getNumberOfLabelsBefore();
                    for (i = 0; i < len; ++i) {
                        int labelBefore = update.getLabelBefore(i);
                        IndexingService.storeUpdateIfIndexExists(updaterMap, update, propertyKeyId, labelBefore, updatesByIndex);
                    }
                    continue block5;
                }
                case CHANGED: {
                    int lenBefore = update.getNumberOfLabelsBefore();
                    int lenAfter = update.getNumberOfLabelsAfter();
                    int i = 0;
                    int j = 0;
                    while (i < lenBefore && j < lenAfter) {
                        int labelAfter;
                        int labelBefore = update.getLabelBefore(i);
                        if (labelBefore == (labelAfter = update.getLabelAfter(j))) {
                            IndexingService.storeUpdateIfIndexExists(updaterMap, update, propertyKeyId, labelAfter, updatesByIndex);
                            ++i;
                            ++j;
                            continue;
                        }
                        if (labelBefore < labelAfter) {
                            ++i;
                            continue;
                        }
                        ++j;
                    }
                    break;
                }
            }
        }
        return updatesByIndex;
    }

    private static void storeUpdateIfIndexExists(IndexUpdaterMap updaterMap, NodePropertyUpdate update, int propertyKeyId, int labelId, Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex) {
        IndexDescriptor descriptor = new IndexDescriptor(labelId, propertyKeyId);
        IndexUpdater updater = updaterMap.getUpdater(descriptor);
        if (updater != null) {
            List<NodePropertyUpdate> indexUpdates = updatesByIndex.get(descriptor);
            if (indexUpdates == null) {
                indexUpdates = new ArrayList<NodePropertyUpdate>();
                updatesByIndex.put(descriptor, indexUpdates);
            }
            indexUpdates.add(update);
        }
    }

    public void dropIndex(IndexRule rule) {
        long indexId = rule.getId();
        IndexProxy index = this.indexMapReference.removeIndexProxy(indexId);
        if (this.state == State.RUNNING) {
            assert (index != null) : "Index " + rule + " doesn't exists";
            try {
                Future<Void> dropFuture = index.drop();
                this.awaitIndexFuture(dropFuture);
            }
            catch (Exception e) {
                throw Exceptions.launderedException(e);
            }
        }
    }

    private IndexProxy createAndStartPopulatingIndexProxy(final long ruleId, final IndexDescriptor descriptor, final SchemaIndexProvider.Descriptor providerDescriptor, final boolean constraint) throws IOException {
        final FlippableIndexProxy flipper = new FlippableIndexProxy();
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexPopulator populator = this.getPopulatorFromProvider(providerDescriptor, ruleId, descriptor, new IndexConfiguration(constraint));
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(descriptor, providerDescriptor, populator, indexUserDescription, this.logger);
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(this.scheduler, descriptor, providerDescriptor, failureDelegateFactory, populator, flipper, this.storeView, indexUserDescription, this.updateableSchemaState, this.logging, this.monitor);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(new IndexProxyFactory(){

            @Override
            public IndexProxy create() {
                try {
                    OnlineIndexProxy onlineProxy = new OnlineIndexProxy(descriptor, providerDescriptor, IndexingService.this.getOnlineAccessorFromProvider(providerDescriptor, ruleId, new IndexConfiguration(constraint)));
                    if (constraint) {
                        return new TentativeConstraintIndexProxy(flipper, onlineProxy);
                    }
                    return onlineProxy;
                }
                catch (IOException e) {
                    return IndexingService.this.createAndStartFailedIndexProxy(ruleId, descriptor, providerDescriptor, constraint, IndexPopulationFailure.failure(e));
                }
            }
        });
        IndexProxy result = this.contractCheckedProxy(flipper, false);
        result.start();
        return result;
    }

    private IndexProxy createAndStartOnlineIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean unique) {
        try {
            IndexAccessor onlineAccessor = this.getOnlineAccessorFromProvider(providerDescriptor, ruleId, new IndexConfiguration(unique));
            IndexProxy result = new OnlineIndexProxy(descriptor, providerDescriptor, onlineAccessor);
            result = this.contractCheckedProxy(result, true);
            return result;
        }
        catch (IOException e) {
            return this.createAndStartFailedIndexProxy(ruleId, descriptor, providerDescriptor, unique, IndexPopulationFailure.failure(e));
        }
    }

    private IndexProxy createAndStartFailedIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean unique, IndexPopulationFailure populationFailure) {
        IndexPopulator indexPopulator = this.getPopulatorFromProvider(providerDescriptor, ruleId, descriptor, new IndexConfiguration(unique));
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexProxy result = new FailedIndexProxy(descriptor, providerDescriptor, indexUserDescription, indexPopulator, populationFailure, this.logger);
        result = this.contractCheckedProxy(result, true);
        return result;
    }

    private IndexProxy createAndStartRecoveringIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        IndexProxy result = new RecoveringIndexProxy(descriptor, providerDescriptor);
        result = this.contractCheckedProxy(result, true);
        return result;
    }

    private IndexPopulator getPopulatorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexDescriptor descriptor, IndexConfiguration config) {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getPopulator(ruleId, descriptor, config);
    }

    private IndexAccessor getOnlineAccessorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexConfiguration config) throws IOException {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getOnlineAccessor(ruleId, config);
    }

    private IndexProxy contractCheckedProxy(IndexProxy result, boolean started) {
        result = new ContractCheckingIndexProxy(result, started);
        return result;
    }

    private IndexDescriptor createDescriptor(IndexRule rule) {
        return new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
    }

    private void awaitIndexFuture(Future<Void> future) throws Exception {
        try {
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw e;
        }
    }

    private void dropRecoveringIndexes(IndexMap indexMap, Map<Long, Pair<IndexDescriptor, SchemaIndexProvider.Descriptor>> recoveringIndexes) throws IOException {
        for (long indexId : recoveringIndexes.keySet()) {
            IndexProxy indexProxy = indexMap.removeIndexProxy(indexId);
            indexProxy.drop();
        }
    }

    public void activateIndex(long indexId) throws IndexNotFoundKernelException, IndexActivationFailedKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getProxyForRule(indexId);
                index.awaitStoreScanCompleted();
                index.activate();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IndexActivationFailedKernelException(e, "Unable to activate index, thread was interrupted.");
        }
    }

    public void validateIndex(long indexId) throws IndexNotFoundKernelException, ConstraintVerificationFailedKernelException, IndexPopulationFailedKernelException {
        this.getProxyForRule(indexId).validate();
    }

    public void flushAll() {
        for (IndexProxy index : this.indexMapReference.getAllIndexProxies()) {
            try {
                index.force();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to force " + index, e);
            }
        }
    }

    private void closeAllIndexes() {
        Iterable<IndexProxy> indexesToStop = this.indexMapReference.clear();
        ArrayList<Future<Void>> indexStopFutures = new ArrayList<Future<Void>>();
        for (IndexProxy indexProxy : indexesToStop) {
            try {
                indexStopFutures.add(indexProxy.close());
            }
            catch (IOException e) {
                this.logger.error("Unable to close index", e);
            }
        }
        for (Future future : indexStopFutures) {
            try {
                this.awaitIndexFuture(future);
            }
            catch (Exception e) {
                this.logger.error("Error awaiting index to close", e);
            }
        }
    }

    private Pair<IndexDescriptor, SchemaIndexProvider.Descriptor> getIndexProxyDescriptors(IndexProxy indexProxy) {
        return Pair.of(indexProxy.getDescriptor(), indexProxy.getProviderDescriptor());
    }

    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexProxy indexProxy : this.indexMapReference.getAllIndexProxies()) {
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterables.concatResourceIterators(snapshots.iterator());
    }

    public static abstract class MonitorAdapter
    implements Monitor {
        @Override
        public void appliedRecoveredData(Iterable<NodePropertyUpdate> updates) {
        }

        @Override
        public void applyingRecoveredData(Collection<Long> nodeIds) {
        }

        @Override
        public void verifyDeferredConstraints() {
        }
    }

    public static interface Monitor {
        public void applyingRecoveredData(Collection<Long> var1);

        public void appliedRecoveredData(Iterable<NodePropertyUpdate> var1);

        public void verifyDeferredConstraints();
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

