/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogCommandReader;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class LegacyLuceneLogCommandReader
implements LegacyLogCommandReader {
    private static final byte ADD_COMMAND = 1;
    private static final byte REMOVE_COMMAND = 2;
    private static final byte DELETE_COMMAND = 3;
    private static final byte CREATE_INDEX_COMMAND = 4;
    public static final byte NODE = 1;
    public static final byte RELATIONSHIP = 2;
    private static final byte VALUE_TYPE_NULL = 0;
    private static final byte VALUE_TYPE_INT = 1;
    private static final byte VALUE_TYPE_LONG = 2;
    private static final byte VALUE_TYPE_FLOAT = 3;
    private static final byte VALUE_TYPE_DOUBLE = 4;
    private static final byte VALUE_TYPE_STRING = 5;

    private static void writeLengthAndString(LogBuffer buffer, String string) throws IOException {
        char[] chars = string.toCharArray();
        buffer.putInt(chars.length);
        buffer.put(chars);
    }

    @Override
    public XaCommand readCommand(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        EntityType entityType;
        buffer.clear();
        buffer.limit(2);
        if (channel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte commandType = buffer.get();
        byte entityTypeByte = buffer.get();
        if (commandType == 4) {
            buffer.clear();
            String name = IoPrimitiveUtils.readLengthAndString(channel, buffer);
            if (name == null) {
                return null;
            }
            int size = IoPrimitiveUtils.readInt(channel, buffer);
            HashMap<String, String> config = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = IoPrimitiveUtils.readLengthAndString(channel, buffer);
                String value = IoPrimitiveUtils.readLengthAndString(channel, buffer);
                if (key == null || value == null) {
                    return null;
                }
                config.put(key, value);
            }
            return new CreateIndexCommand(entityTypeByte, name, config);
        }
        buffer.clear();
        buffer.limit(17);
        if (channel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        if (entityTypeByte == 1) {
            entityType = EntityType.NODE;
        } else if (entityTypeByte == 2) {
            entityType = EntityType.RELATIONSHIP;
        } else {
            return null;
        }
        int indexNameLength = buffer.getInt();
        long entityId = buffer.getLong();
        int keyCharLength = buffer.getInt();
        byte valueType = buffer.get();
        String indexName = IoPrimitiveUtils.readString(channel, buffer, indexNameLength);
        if (indexName == null) {
            return null;
        }
        String key = null;
        if (keyCharLength != -1 && (key = IoPrimitiveUtils.readString(channel, buffer, keyCharLength)) == null) {
            return null;
        }
        Object value = null;
        if (valueType >= 1 && valueType <= 4) {
            switch (valueType) {
                case 1: {
                    value = IoPrimitiveUtils.readInt(channel, buffer);
                    break;
                }
                case 2: {
                    value = IoPrimitiveUtils.readLong(channel, buffer);
                    break;
                }
                case 3: {
                    value = IoPrimitiveUtils.readFloat(channel, buffer);
                    break;
                }
                case 4: {
                    value = IoPrimitiveUtils.readDouble(channel, buffer);
                }
            }
        } else if (valueType == 5) {
            value = IoPrimitiveUtils.readLengthAndString(channel, buffer);
        }
        if (valueType != 0 && value == null) {
            return null;
        }
        Long startNodeId = null;
        Long endNodeId = null;
        if (commandType == 1 && entityTypeByte == 2) {
            startNodeId = IoPrimitiveUtils.readLong(channel, buffer);
            endNodeId = IoPrimitiveUtils.readLong(channel, buffer);
            if (startNodeId == null || endNodeId == null) {
                return null;
            }
        }
        IndexIdentifier identifier = new IndexIdentifier(entityTypeByte, entityType, indexName);
        switch (commandType) {
            case 1: {
                return entityTypeByte == 1 ? new AddCommand(identifier, entityTypeByte, entityId, key, value) : new AddRelationshipCommand(identifier, entityTypeByte, new RelationshipId(entityId, startNodeId, endNodeId), key, value);
            }
            case 2: {
                return new RemoveCommand(identifier, entityTypeByte, entityId, key, value);
            }
            case 3: {
                return new DeleteCommand(identifier);
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }

    static class CreateIndexCommand
    extends LuceneCommand {
        static final IndexIdentifier FAKE_IDENTIFIER = new IndexIdentifier(9, null, "create index");
        private final String name;
        private final Map<String, String> config;

        CreateIndexCommand(byte entityType, String name, Map<String, String> config) {
            super(FAKE_IDENTIFIER, entityType, -1L, null, null, (byte)4);
            this.name = name;
            this.config = config;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put(this.type);
            buffer.put(this.entityType);
            LegacyLuceneLogCommandReader.writeLengthAndString(buffer, this.name);
            buffer.putInt(this.config.size());
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                LegacyLuceneLogCommandReader.writeLengthAndString(buffer, entry.getKey());
                LegacyLuceneLogCommandReader.writeLengthAndString(buffer, entry.getValue());
            }
        }
    }

    static class DeleteCommand
    extends LuceneCommand {
        DeleteCommand(IndexIdentifier indexId) {
            super(indexId, indexId.entityTypeByte, -1L, "", "", (byte)3);
        }
    }

    static class RemoveCommand
    extends LuceneCommand {
        RemoveCommand(IndexIdentifier indexId, byte entityType, Object entityId, String key, Object value) {
            super(indexId, entityType, entityId, key, value, (byte)2);
        }
    }

    static class AddRelationshipCommand
    extends LuceneCommand {
        AddRelationshipCommand(IndexIdentifier indexId, byte entityType, RelationshipId entityId, String key, Object value) {
            super(indexId, entityType, entityId, key, value, (byte)1);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            super.writeToFile(buffer);
            buffer.putLong(((RelationshipId)this.entityId).startNode);
            buffer.putLong(((RelationshipId)this.entityId).endNode);
        }
    }

    static class AddCommand
    extends LuceneCommand {
        AddCommand(IndexIdentifier indexId, byte entityType, Object entityId, String key, Object value) {
            super(indexId, entityType, entityId, key, value, (byte)1);
        }
    }

    private static class LuceneCommand
    extends XaCommand {
        final IndexIdentifier indexId;
        final Object entityId;
        final String key;
        final Object value;
        final byte type;
        final byte entityType;

        LuceneCommand(IndexIdentifier indexId, byte entityType, Object entityId, String key, Object value, byte type) {
            assert (entityType == 1 || entityType == 2);
            this.indexId = indexId;
            this.entityType = entityType;
            this.entityId = entityId;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public Class<? extends PropertyContainer> getEntityType() {
            if (this.entityType == 1) {
                return Node.class;
            }
            if (this.entityType == 2) {
                return Relationship.class;
            }
            throw new IllegalArgumentException("Unknown entity type " + this.entityType);
        }

        @Override
        public void execute() {
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put(this.type);
            buffer.put(this.entityType);
            char[] indexName = this.indexId.indexName.toCharArray();
            buffer.putInt(indexName.length);
            long id = this.entityId instanceof Long ? (Long)this.entityId : ((RelationshipId)this.entityId).id;
            buffer.putLong(id);
            char[] key = this.key == null ? null : this.key.toCharArray();
            buffer.putInt(key == null ? -1 : key.length);
            int valueType = 0;
            valueType = this.value == null ? 0 : (this.value instanceof Number ? (this.value instanceof Float ? 3 : (this.value instanceof Double ? 4 : (this.value instanceof Long ? 2 : 1))) : 5);
            buffer.put((byte)valueType);
            buffer.put(indexName);
            if (key != null) {
                buffer.put(key);
            }
            if (valueType == 5) {
                char[] charValue = this.value.toString().toCharArray();
                buffer.putInt(charValue.length);
                buffer.put(charValue);
            } else if (valueType != 0) {
                Number number = (Number)this.value;
                switch (valueType) {
                    case 3: {
                        buffer.putInt(Float.floatToRawIntBits(number.floatValue()));
                        break;
                    }
                    case 4: {
                        buffer.putLong(Double.doubleToRawLongBits(number.doubleValue()));
                        break;
                    }
                    case 2: {
                        buffer.putLong(number.longValue());
                        break;
                    }
                    case 1: {
                        buffer.putInt(number.intValue());
                        break;
                    }
                    default: {
                        throw new Error("Should not reach here.");
                    }
                }
            }
        }
    }

    private static class RelationshipId {
        final long id;
        final long startNode;
        final long endNode;

        RelationshipId(long id, long startNode, long endNode) {
            this.id = id;
            this.startNode = startNode;
            this.endNode = endNode;
        }
    }

    private static class IndexIdentifier {
        final String indexName;
        final EntityType entityType;
        final byte entityTypeByte;

        public IndexIdentifier(byte entityTypeByte, EntityType entityType, String indexName) {
            this.entityTypeByte = entityTypeByte;
            this.entityType = entityType;
            this.indexName = indexName;
        }
    }
}

