/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogCommandReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogIoUtil;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogicalLogCommandReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLuceneLogCommandReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyIndexStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyStoreReader;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;

public class LegacyStore
implements Closeable {
    public static final String LEGACY_VERSION = "v0.A.0";
    private static final String NIONEO_LOGICAL_LOG_PATTERN = "nioneo_logical\\.log\\.v.*";
    private static final String LUCENE_LOGICAL_LOG_PATTERN = "lucene\\.log\\.v.*";
    private final File storageFileName;
    private final Collection<Closeable> allStoreReaders = new ArrayList<Closeable>();
    private LegacyNodeStoreReader nodeStoreReader;
    private LegacyPropertyIndexStoreReader propertyIndexReader;
    private LegacyPropertyStoreReader propertyStoreReader;
    private final FileSystemAbstraction fs;

    public LegacyStore(FileSystemAbstraction fs, File storageFileName) throws IOException {
        this.fs = fs;
        this.storageFileName = storageFileName;
        LegacyStore.assertLegacyAndCurrentVersionHaveSameLength(LEGACY_VERSION, "v0.A.1");
        this.initStorage();
    }

    static void assertLegacyAndCurrentVersionHaveSameLength(String legacyVersion, String currentVersion) {
        if (UTF8.encode(legacyVersion).length != UTF8.encode(currentVersion).length) {
            throw new IllegalStateException("Encoded version string length must remain the same between versions");
        }
    }

    protected void initStorage() throws IOException {
        this.nodeStoreReader = new LegacyNodeStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".nodestore.db"));
        this.allStoreReaders.add(this.nodeStoreReader);
        this.propertyIndexReader = new LegacyPropertyIndexStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db.index"));
        this.allStoreReaders.add(this.propertyIndexReader);
        this.propertyStoreReader = new LegacyPropertyStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db"));
        this.allStoreReaders.add(this.propertyStoreReader);
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    @Override
    public void close() throws IOException {
        for (Closeable storeReader : this.allStoreReaders) {
            storeReader.close();
        }
    }

    private void copyStore(File targetBaseStorageFileName, String storeNamePart, String versionTrailer) throws IOException {
        File targetStoreFileName = new File(targetBaseStorageFileName.getPath() + storeNamePart);
        this.fs.copyFile(new File(this.storageFileName + storeNamePart), targetStoreFileName);
        this.setStoreVersionTrailer(targetStoreFileName, versionTrailer);
        this.fs.copyFile(new File(this.storageFileName + storeNamePart + ".id"), new File(targetBaseStorageFileName + storeNamePart + ".id"));
    }

    private void setStoreVersionTrailer(File targetStoreFileName, String versionTrailer) throws IOException {
        try (StoreChannel fileChannel = this.fs.open(targetStoreFileName, "rw");){
            byte[] trailer = UTF8.encode(versionTrailer);
            fileChannel.position(fileChannel.size() - (long)trailer.length);
            fileChannel.write(ByteBuffer.wrap(trailer));
        }
    }

    public void copyNeoStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), "", neoStore.getTypeAndVersionDescriptor());
    }

    public void copyRelationshipStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshipstore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    public void copyRelationshipTypeTokenStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
    }

    public void copyRelationshipTypeTokenNameStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db.names", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicStringPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.strings", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicArrayPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.arrays", CommonAbstractStore.buildTypeDescriptorAndVersion("ArrayPropertyStore"));
    }

    public LegacyNodeStoreReader getNodeStoreReader() {
        return this.nodeStoreReader;
    }

    public LegacyPropertyIndexStoreReader getPropertyIndexReader() {
        return this.propertyIndexReader;
    }

    public LegacyPropertyStoreReader getPropertyStoreReader() {
        return this.propertyStoreReader;
    }

    static void readIntoBuffer(StoreChannel fileChannel, ByteBuffer buffer, int nrOfBytes) {
        buffer.clear();
        buffer.limit(nrOfBytes);
        try {
            fileChannel.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buffer.flip();
    }

    public void copyLegacyIndexStoreFile(File toDirectory) throws IOException {
        File legacyDirectory = this.storageFileName.getParentFile();
        File fromFile = new File(legacyDirectory, "index.db");
        if (fromFile.exists()) {
            File toFile = new File(toDirectory, "index.db");
            this.fs.copyFile(fromFile, toFile);
        }
    }

    public StoreChannel beginTranslatingLastTransactionLog(NeoStore neoStore) throws IOException {
        File legacyDirectory = this.storageFileName.getParentFile();
        File migratedDirectory = neoStore.getStorageFileName().getParentFile();
        String logFilenamePattern = NIONEO_LOGICAL_LOG_PATTERN;
        return this.prepareLogTranslation(legacyDirectory, migratedDirectory, logFilenamePattern);
    }

    public StoreChannel beginTranslatingLastLuceneLog(NeoStore neoStore) throws IOException {
        File legacyDirectory = new File(this.storageFileName.getParentFile(), "index");
        File migratedDirectory = new File(neoStore.getStorageFileName().getParentFile(), "index");
        this.fs.mkdirs(migratedDirectory);
        String logFilenamePattern = LUCENE_LOGICAL_LOG_PATTERN;
        return this.prepareLogTranslation(legacyDirectory, migratedDirectory, logFilenamePattern);
    }

    private StoreChannel prepareLogTranslation(File legacyDirectory, File migratedDirectory, String logFilenamePattern) throws IOException {
        File lastLegacyLog = this.findMostRecentLog(legacyDirectory, logFilenamePattern);
        if (lastLegacyLog == null) {
            return null;
        }
        File translatedLogFile = new File(migratedDirectory, lastLegacyLog.getName());
        return this.fs.open(translatedLogFile, "rw");
    }

    private File findMostRecentLog(File directory, String logFilenamePattern) {
        final Pattern logFileName = Pattern.compile(logFilenamePattern);
        FilenameFilter logFiles = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return logFileName.matcher(name).find();
            }
        };
        Object[] files = this.fs.listFiles(directory, logFiles);
        if (files != null && files.length > 0) {
            Arrays.sort(files);
            return files[files.length - 1];
        }
        return null;
    }

    public ResourceIterator<LogEntry> iterateLastTransactionLogEntries(LogBuffer logBuffer) throws IOException {
        File legacyDirectory = this.storageFileName.getParentFile();
        String logFilenamePattern = NIONEO_LOGICAL_LOG_PATTERN;
        LegacyLogicalLogCommandReader commandReader = new LegacyLogicalLogCommandReader();
        return this.iterateLogEntries(logBuffer, legacyDirectory, logFilenamePattern, commandReader);
    }

    public ResourceIterator<LogEntry> iterateLastLuceneLogEntries(LogBuffer logBuffer) throws IOException {
        File legacyDirectory = new File(this.storageFileName.getParentFile(), "index");
        String logFilenamePattern = LUCENE_LOGICAL_LOG_PATTERN;
        LegacyLuceneLogCommandReader commandReader = new LegacyLuceneLogCommandReader();
        return this.iterateLogEntries(logBuffer, legacyDirectory, logFilenamePattern, commandReader);
    }

    private ResourceIterator<LogEntry> iterateLogEntries(LogBuffer logBuffer, File legacyDirectory, String logFilenamePattern, final LegacyLogCommandReader commandReader) throws IOException {
        File lastLegacyLog = this.findMostRecentLog(legacyDirectory, logFilenamePattern);
        final StoreChannel channel = this.fs.open(lastLegacyLog, "r");
        final ByteBuffer buffer = ByteBuffer.allocate(100000);
        long[] header = LegacyLogIoUtil.readLogHeader(buffer, channel, false);
        if (header != null) {
            ByteBuffer headerBuf = ByteBuffer.allocate(16);
            LogIoUtils.writeLogHeader(headerBuf, header[0], header[1]);
            logBuffer.put(headerBuf.array());
        }
        Resource resource = this.channelAsResource(channel);
        return ResourceClosingIterator.newResourceIterator(resource, new PrefetchingIterator<LogEntry>(){

            @Override
            protected LogEntry fetchNextOrNull() {
                try {
                    return LegacyLogIoUtil.readEntry(buffer, channel, commandReader);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read legacy log entry", e);
                }
            }
        });
    }

    private Resource channelAsResource(final StoreChannel channel) {
        return new Resource(){

            @Override
            public void close() {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close legacy log channel", e);
                }
            }
        };
    }
}

