/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

final class CharProperty
extends DefinedProperty {
    private final char value;

    CharProperty(int propertyKeyId, char value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Character) {
            return this.value == ((Character)other).charValue();
        }
        return this.valueCompare(Character.valueOf(this.value), other);
    }

    @Override
    public Character value() {
        return Character.valueOf(this.value);
    }

    @Override
    int valueHash() {
        return this.value;
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return this.value == ((CharProperty)that).value;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(8);
    }
}

